package com.bxm.warcar.mq.redis;

import com.bxm.warcar.mq.*;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UUIDHelper;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

/**
 * @author allen
 * @date 2019/10/21
 * @since 1.0.0
 */
public class JedisProducer implements Producer {

    private final JedisPool jedisPool;

    public JedisProducer(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public SendResult send(Message message) throws SendException {
        String topic = message.getTopic();
        String id = UUIDHelper.generate();
        message.setMsgId(id);
        Jedis jedis = null;

        try {
            jedis = jedisPool.getResource();
            Long row = jedis.rpush(RedisConst.key(topic), JsonHelper.convert(message));

            if (null != row && row >= 1) {
                return new SendResult(id);
            }
        } catch (Exception e) {
            throw new SendException(e.getMessage());
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        throw new SendException("0");
    }

    @Override
    public void start() {

    }

    @Override
    public void close() {

    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public Type getType() {
        return Type.Redis;
    }
}
