package com.bxm.warcar.mq.redis;

import com.bxm.warcar.mq.*;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UUIDHelper;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

/**
 * <h3>广播模式发布消息</h3>
 * <p>
 *     订阅消息 {@link JedisSubscriber}
 *     注意此方法不支持事务,并且当消息订阅者消费速度慢,会出现问题
 *     集群消息可选择{@link JedisProducer}
 * </p>
 *
 * @author hcmony
 * @since V1.0.0, 2020/01/06 09:50
 */
public class JedisPublisher implements Producer {

    private final JedisPool jedisPool;

    public JedisPublisher(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public SendResult send(Message message) throws SendException {
        String topic = message.getTopic();
        String id = UUIDHelper.generate();
        message.setMsgId(id);
        Jedis jedis = null;

        try {
            jedis = jedisPool.getResource();
            Long row = jedis.publish(topic, JsonHelper.convert(message));

            if (null != row && row >= 1) {
                return new SendResult(id);
            }
        } catch (Exception e) {
            throw new SendException(e.getMessage());
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        throw new SendException("0");
    }

    @Override
    public void start() {

    }

    @Override
    public void close() {

    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public Type getType() {
        return Type.Redis;
    }
}
