package com.bxm.warcar.mq.redis;

import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * <h3>广播模式接收消息</h3>
 * <p>
 *     发布消息 {@link JedisPublisher}
 *     注意此方法不支持事务,集群消息可选择{@link JedisConsumer}
 * </p>
 *
 * @author hcmony
 * @since V1.0.0, 2020/01/06 09:50
 */
public class JedisSubscriber extends LifeCycle implements Consumer {

    private static final Logger LOGGER = LoggerFactory.getLogger(RedisConsumer.class);
    private final JedisPool jedisPool;
    private final SingleMessageListener messageListener;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public JedisSubscriber(JedisPool jedisPool, SingleMessageListener messageListener) {
        this.jedisPool = jedisPool;
        this.messageListener = messageListener;
    }


    @Override
    protected void doInit() {
        String topic = messageListener.getTopic();
        if (shutdown.get()) {
            return;
        }
        if (null == jedisPool || jedisPool.isClosed()) {
            try {
                Thread.sleep(1000L);
            } catch (InterruptedException ignore) {
            }
            return;
        }
        final Jedis jedis = jedisPool.getResource();
        try {
            jedis.subscribe(new JedisPubSub() {
                @Override
                public void onMessage(String channel, String message) {
                    if (null != message) {
                        Message message1 = JsonHelper.convert(message, Message.class);
                        messageListener.consume(message1, message1);
                    }
                }
            },topic);

        } catch (Exception e) {
            LOGGER.error("", e);
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }

    }

    @Override
    protected void doDestroy() {
        if (jedisPool != null){
            jedisPool.destroy();
        }
    }

    @Override
    public void suspend() {

    }

    @Override
    public void shutdown() {
        this.doDestroy();
    }

    @Override
    public void start() {
        this.doInit();
    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public Listener getMessageListener() {
        return messageListener;
    }
}
