package com.bxm.warcar.mq.redis;

import com.bxm.warcar.mq.*;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UUIDHelper;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

/**
 * <h3>广播模式发布消息</h3>
 * <p>
 *     订阅消息 {@link JedisSubscriber}
 *     注意此方法不支持事务,并且当消息订阅者消费速度慢,会出现问题
 *     集群消息可选择{@link JedisProducer}
 *      1，如果一个客户端订阅了频道，但自己读取消息的速度却不够快的话，那么不断积压的消息会使redis输出缓冲区的体积变得越来越大，这可能使得redis本身的速度变慢，甚至直接崩溃。
 *      2，这和数据传输可靠性有关，如果在订阅方断线，那么他将会丢失所有在短线期间发布者发布的消息，这个让绝不多数人都很失望吧
 *      3，如果消费失败，不支持重试
 * </p>
 *
 * @author hcmony
 * @since V1.0.0, 2020/01/06 09:50
 */
public class JedisPublisher implements Producer {

    private final JedisPool jedisPool;

    public JedisPublisher(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public SendResult send(Message message) throws SendException {
        String topic = message.getTopic();
        String id = UUIDHelper.generate();
        message.setMsgId(id);
        Jedis jedis = null;

        try {
            jedis = jedisPool.getResource();
            Long row = jedis.publish(topic, JsonHelper.convert(message));

            if (null != row && row >= 1) {
                return new SendResult(id);
            }
        } catch (Exception e) {
            throw new SendException(e.getMessage());
        } finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        throw new SendException("0");
    }

    @Override
    public void start() {

    }

    @Override
    public void close() {

    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public Type getType() {
        return Type.Redis;
    }
}
