/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.redis;

import com.bxm.warcar.mq.ConsumeStatus;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.redis.RedisConst;
import com.bxm.warcar.mq.redis.RedisConsumer;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.LifeCycle;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class JedisConsumer
extends LifeCycle
implements Consumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisConsumer.class);
    private final ThreadPoolExecutor consumer = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("JedisConsumer"));
    private final JedisPool jedisPool;
    private final SingleMessageListener messageListener;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public JedisConsumer(JedisPool jedisPool, SingleMessageListener messageListener) {
        this.jedisPool = jedisPool;
        this.messageListener = messageListener;
    }

    protected void doInit() {
        String topic = this.messageListener.getTopic();
        this.consumer.execute(() -> {
            while (!this.shutdown.get()) {
                if (null == this.jedisPool || this.jedisPool.isClosed()) {
                    this.threadDelay(1000L);
                    continue;
                }
                Jedis jedis = null;
                jedis = this.jedisPool.getResource();
                try {
                    List list = jedis.blpop(1, RedisConst.key(topic));
                    if (CollectionUtils.isEmpty((Collection)list)) continue;
                    for (int index = 0; index < list.size(); ++index) {
                        ConsumeStatus status;
                        String json;
                        Message message;
                        if (index == 0 || null == (message = (Message)JsonHelper.convert((String)(json = (String)list.get(index)), Message.class)) || (status = this.messageListener.consume(message, jedis)) != ConsumeStatus.RECONSUME_LATER) continue;
                        jedis.rpush(RedisConst.key(topic), new String[]{json});
                        this.threadDelay(500L);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("", (Throwable)e);
                }
                finally {
                    if (null == jedis) continue;
                    jedis.close();
                }
            }
        });
    }

    private void threadDelay(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void doDestroy() {
        this.consumer.shutdown();
        this.shutdown.compareAndSet(false, true);
        try {
            this.consumer.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void suspend() {
    }

    @Override
    public void shutdown() {
        this.doDestroy();
    }

    @Override
    public void start() {
        this.doInit();
    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public Listener getMessageListener() {
        return this.messageListener;
    }
}

