/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.redis;

import com.bxm.warcar.mq.ConsumeStatus;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.redis.RedisConst;
import com.bxm.warcar.utils.LifeCycle;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisConsumer
extends LifeCycle
implements Consumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisConsumer.class);
    private final ThreadPoolExecutor consumer = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("RedisConsumer"));
    private final RedisTemplate<String, Message> redisTemplate;
    private final SingleMessageListener messageListener;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public RedisConsumer(RedisTemplate<String, Message> redisTemplate, SingleMessageListener messageListener) {
        this.redisTemplate = redisTemplate;
        this.messageListener = messageListener;
    }

    protected void doInit() {
        String topic = this.messageListener.getTopic();
        this.consumer.execute(() -> {
            while (!this.shutdown.get()) {
                try {
                    ConsumeStatus status;
                    Message message = (Message)this.redisTemplate.opsForList().leftPop((Object)RedisConst.key(topic), 1L, TimeUnit.SECONDS);
                    if (null == message || (status = this.messageListener.consume(message, this.redisTemplate)) != ConsumeStatus.RECONSUME_LATER) continue;
                    this.redisTemplate.opsForList().rightPush((Object)RedisConst.key(topic), (Object)message);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                catch (Exception e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        });
    }

    protected void doDestroy() {
        this.consumer.shutdown();
        this.shutdown.compareAndSet(false, true);
        try {
            this.consumer.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void suspend() {
    }

    @Override
    public void shutdown() {
        this.doDestroy();
    }

    @Override
    public void start() {
        this.doInit();
    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public Listener getMessageListener() {
        return this.messageListener;
    }
}

