package com.bxm.warcar.pushable.consumer.test;

import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.StringHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * @author huxiao
 * @date 2019-12-12
 */
@Slf4j
@CachePush("DEMO")
@Configuration
public class PushableCachePushable implements Pushable {

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        log.info("parameters={}, data={}", parameters, StringHelper.convert(data));
    }
}
