/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.pushable.producer.test;

import com.bxm.warcar.integration.pushable.CachePushException;
import com.bxm.warcar.integration.pushable.CachePushableService;
import com.bxm.warcar.integration.pushable.message.MessageEntity;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PushableProducer {
    private static final Logger log = LoggerFactory.getLogger(PushableProducer.class);
    private final CachePushableService cachePushableService;

    public PushableProducer(CachePushableService cachePushableService) {
        this.cachePushableService = cachePushableService;
    }

    @PutMapping(value={"/send/{serviceName}"})
    public ResponseEntity<String> push(@PathVariable(value="serviceName") String serviceName, @RequestParam Map<String, Object> parameters, @RequestParam(value="topic") String topic, @RequestBody byte[] data) {
        MessageEntity entity = new MessageEntity(serviceName, parameters, data);
        try {
            return ResponseEntity.ok((Object)this.cachePushableService.push(entity, topic));
        }
        catch (CachePushException e) {
            log.error("push: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.SERVICE_UNAVAILABLE).body((Object)e.getMessage());
        }
    }
}

