package com.bxm.warcar.pushable.producer.test;

import com.bxm.warcar.integration.pushable.CachePushException;
import com.bxm.warcar.integration.pushable.CachePushableService;
import com.bxm.warcar.integration.pushable.message.MessageEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @author huxiao
 * @date 2019-12-12
 */
@Slf4j
@RestController
public class PushableProducer {

    private final CachePushableService cachePushableService;

    public PushableProducer(CachePushableService cachePushableService) {
        this.cachePushableService = cachePushableService;
    }

    @PutMapping("/send/{serviceName}")
    public ResponseEntity<String> push(@PathVariable("serviceName") String serviceName,
                                       @RequestParam Map<String, Object> parameters,
                                       @RequestParam("topic") String topic,
                                       @RequestBody byte[] data) {
        MessageEntity entity = new MessageEntity(serviceName, parameters, data);
        try {
            return ResponseEntity.ok(cachePushableService.push(entity, topic));
        } catch (CachePushException e) {
            log.error("push: ", e);
            return ResponseEntity.status(HttpStatus.SERVICE_UNAVAILABLE).body(e.getMessage());
        }
    }
}
