/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.sentinel;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.bxm.warcar.utils.StringHelper;
import com.bxm.warcar.zk.ZkClientHolder;
import com.bxm.warcar.zk.listener.NodeChangedListener;
import com.bxm.warcar.zk.listener.node.NodeChanged;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperDataSource<T>
extends AbstractDataSource<byte[], T> {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperDataSource.class);
    private final ExecutorService pool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), (ThreadFactory)new NamedThreadFactory("sentinel-zookeeper-ds-update"), new ThreadPoolExecutor.DiscardOldestPolicy());
    private final String path;
    private ZkClientHolder zkClientHolder;
    private NodeChanged nodeChanged;
    private NodeChangedListener listener;

    public ZooKeeperDataSource(ZkClientHolder zkClientHolder, String groupId, String dataId, Converter<byte[], T> parser) {
        super(parser);
        Preconditions.checkNotNull((Object)zkClientHolder);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)groupId));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)dataId));
        this.zkClientHolder = zkClientHolder;
        this.path = this.getPath(groupId, dataId);
        this.init();
    }

    private void init() {
        this.creatingPathIfNeeded();
        this.initZookeeperListener();
    }

    private void creatingPathIfNeeded() {
        try {
            CuratorFramework zkClient = this.zkClientHolder.get();
            Stat stat = (Stat)zkClient.checkExists().forPath(this.path);
            if (Objects.isNull(stat)) {
                String forPath = (String)zkClient.create().creatingParentsIfNeeded().forPath(this.path, StringHelper.convert((String)"{}"));
                log.info(String.format("[ZookeeperDataSource] create path %s", forPath));
            }
        }
        catch (Exception ex) {
            log.warn("[ZookeeperDataSource] Error when creating path", (Throwable)ex);
        }
    }

    private void initZookeeperListener() {
        try {
            this.listener = new NodeChangedListener(){

                public void update(String path, byte[] data) {
                    Object newValue = ZooKeeperDataSource.this.parser.convert((Object)data);
                    if (Objects.isNull(newValue)) {
                        return;
                    }
                    log.info("[ZookeeperDataSource] New property value received for ({}): {}", (Object)path, newValue);
                    ZooKeeperDataSource.this.getProperty().updateValue(newValue);
                }

                public ExecutorService getExecutorService() {
                    return ZooKeeperDataSource.this.pool;
                }
            };
            this.nodeChanged = new NodeChanged(this.zkClientHolder, this.path, this.listener);
            this.nodeChanged.init();
        }
        catch (Exception e) {
            log.warn("[ZookeeperDataSource] Error occurred when initializing Zookeeper data source", (Throwable)e);
        }
    }

    public byte[] readSource() throws Exception {
        return (byte[])this.zkClientHolder.get().getData().forPath(this.path);
    }

    public void close() throws Exception {
        if (Objects.nonNull(this.nodeChanged)) {
            this.nodeChanged.destroy();
        }
        this.pool.shutdown();
    }

    private String getPath(String groupId, String dataId) {
        return String.format("/%s/%s", groupId, dataId);
    }
}

