/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.sentinel;

import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import com.bxm.warcar.sentinel.SentinelRuleProperties;
import com.bxm.warcar.sentinel.ZooKeeperDataSource;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.LifeCycle;
import com.bxm.warcar.zk.ZkClientHolder;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.ConfigurableEnvironment;

public class ZooKeeperDataSourceRegistryFactory
extends LifeCycle {
    private ZooKeeperDataSource<List<FlowRule>> flowRuleDataSource;
    private ZooKeeperDataSource<List<SystemRule>> systemRuleDataSource;
    private ZooKeeperDataSource<List<DegradeRule>> degradeRuleDataSource;
    private ZooKeeperDataSource<List<AuthorityRule>> authorityRuleDataSource;

    public ZooKeeperDataSourceRegistryFactory(ConfigurableEnvironment environment, ZkClientHolder zkClientHolder) {
        String groupId = "sentinel";
        String dataId = this.getApplicationId(environment);
        this.flowRuleDataSource = new ZooKeeperDataSource(zkClientHolder, groupId, dataId, source -> this.parse((byte[])source).getFlowRules());
        this.systemRuleDataSource = new ZooKeeperDataSource(zkClientHolder, groupId, dataId, source -> this.parse((byte[])source).getSystemRules());
        this.degradeRuleDataSource = new ZooKeeperDataSource(zkClientHolder, groupId, dataId, source -> this.parse((byte[])source).getDegradeRules());
        this.authorityRuleDataSource = new ZooKeeperDataSource(zkClientHolder, groupId, dataId, source -> this.parse((byte[])source).getAuthorityRules());
    }

    private SentinelRuleProperties parse(byte[] json) {
        return (SentinelRuleProperties)JsonHelper.convert((byte[])json, SentinelRuleProperties.class);
    }

    private String getApplicationId(ConfigurableEnvironment environment) {
        String name = environment.getProperty("spring.application.name");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"Not set value of 'spring.application.name'!");
        return name;
    }

    protected void doInit() {
        FlowRuleManager.register2Property((SentinelProperty)this.flowRuleDataSource.getProperty());
        SystemRuleManager.register2Property((SentinelProperty)this.systemRuleDataSource.getProperty());
        DegradeRuleManager.register2Property((SentinelProperty)this.degradeRuleDataSource.getProperty());
        AuthorityRuleManager.register2Property((SentinelProperty)this.authorityRuleDataSource.getProperty());
    }

    protected void doDestroy() {
        try {
            this.flowRuleDataSource.close();
            this.systemRuleDataSource.close();
            this.degradeRuleDataSource.close();
            this.authorityRuleDataSource.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

