package com.bxm.warcar.useragent.tiger;

import com.bxm.warcar.useragent.UserAgent;
import com.bxm.warcar.useragent.UserAgentParser;
import com.tiger.useragent.Parser;
import com.tiger.useragent.UserAgentInfo;

import java.io.IOException;

/**
 * @author allen
 * @date 2019/5/15
 * @since 1.0.0
 */
public class TigerUserAgentParser implements UserAgentParser {

    private final Parser parser;

    public TigerUserAgentParser() {
        try {
            this.parser = com.tiger.useragent.UserAgentParser.getInstance();
        } catch (IOException e) {
            throw new RuntimeException("initialize failed: ", e);
        }
    }

    @Override
    public UserAgent parser(String useragent) {
        UserAgentInfo userAgentInfo = parser.parse(useragent);
        return new TigerUserAgent(userAgentInfo);
    }
}
