package com.bxm.warcar.useragent;

/**
 * User Agent
 * @author allen
 * @date 2019/5/15
 * @since 1.0.0
 */
public interface UserAgent {

    /**
     * 返回操作系统名称
     * @return 如：iOS / Android
     */
    CharSequence getOs();

    /**
     * 返回操作系统名称及版本详情
     * @return 如：iOS 12.2
     */
    CharSequence getOsDetail();

    /**
     * 返回浏览器名称
     * @return 如：Chrome / Safari / Wechat / QQ / UC / iQiyi
     */
    CharSequence getBrowser();

    /**
     * 返回浏览器名称及版本号详情
     * @return 如：QQ Mobile 6.2
     */
    CharSequence getBrowserDetail();

    /**
     * 返回设备类型
     * @return 如：Phone / PC / TV / Pad
     */
    CharSequence getDeviceType();

    /**
     * 返回设备品牌
     * @return 如：Apple / Huawei / vivo / Xiaomi
     */
    CharSequence getDeviceBrand();

    /**
     * 返回设备品牌型号及版本名称
     * @return 如：Apple iPhone / Huawei DIG-AL00 / Windows XP
     */
    CharSequence getDeviceName();

    /**
     * 是否为移动电话
     * @return true / false
     */
    Boolean isMobilePhone();

    /**
     * 返回网络类型
     * @return 如：2G / 3G / WiFi
     */
    CharSequence getNetType();
}
