package com.bxm.warcar.utils;

import org.apache.commons.lang.StringUtils;

import javax.servlet.http.HttpServletRequest;


public class IpHelper {


    /**
     * 获取客户端IP
     *
     * @param request
     * @return java.lang.String
     */
    public static String getIpFromHeader(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        String ip = request.getHeader("X-Forwarded-For");
        if (org.apache.commons.lang3.StringUtils.isNotBlank(ip) && !"unknown".equalsIgnoreCase(ip)) {
            return ip.indexOf(',') == -1 ? ip : ip.substring(0, ip.indexOf(','));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    /**
     *  取前两位的数字
     * @param ip
     * @return
     */
    public static String getIpNoDotTwo(String ip){
        if(StringUtils.isBlank(ip)){
            return "0";
        }
        String[] ips = ip.split("\\.");
        if(ips.length != 4){
            return"0";
        }
        return ips[0]+ips[1];
    }


    /**
     *  取去掉 "." 的所有的数字
     * @param ip
     * @return
     */
    public static String getIpNoDot(String ip){
        if(StringUtils.isBlank(ip)){
            return "0";
        }
        String[] ips = ip.split("\\.");
        if(ips.length != 4){
            return"0";
        }
        return ip.replace(".","");
    }

    /**
     * 将标准格式的ip中转化成int类型的整数
     * 通过左移位操作（<<）给每一段的数字加权，第一段的权为2的24次方，第二段的权为2的16次方，第三段的权为2的8次方，最后一段的权为1
     * ip格式不对时返回0
     * @param ip 0.0.0.0格式的ip
     */
    public static int getIntIp(String ip){
        if(StringUtils.isBlank(ip)){
            return 0;
        }
        String[] ips = ip.split("\\.");
        if(ips.length != 4){
            return 0;
        }
        return (Integer.parseInt(ips[0]) << 24) + (Integer.parseInt(ips[1]) << 16) + (Integer.parseInt(ips[2]) << 8) + Integer.parseInt(ips[3]);
    }

    /**
     * 将整型ip转换未string标准格式的ip
     * 1、将整数值进行右移位操作（>>>），右移24位，右移时高位补0，得到的数字即为第一段IP。
     * 2、通过与操作符（&）将整数值的高8位设为0，再右移16位，得到的数字即为第二段IP。
     * 3、通过与操作符吧整数值的高16位设为0，再右移8位，得到的数字即为第三段IP。
     * 4、通过与操作符吧整数值的高24位设为0，得到的数字即为第四段IP。
     * @param intIp
     * @return
     */
    public static String getStringIp(int intIp) {
        StringBuffer sb = new StringBuffer("");
        // 直接右移24位
        sb.append(String.valueOf((intIp >>> 24)));
        sb.append(".");
        // 将高8位置0，然后右移16位
        sb.append(String.valueOf((intIp & 0x00FFFFFF) >>> 16));
        sb.append(".");
        // 将高16位置0，然后右移8位
        sb.append(String.valueOf((intIp & 0x0000FFFF) >>> 8));
        sb.append(".");
        // 将高24位置0
        sb.append(String.valueOf((intIp & 0x000000FF)));
        return sb.toString();
    }



}
