package com.bxm.warcar.utils.random;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.RandomUtils;

/**
 * 根据权重随机命中某项<br/>
 *
 * @author kerry.jiang
 * @date 2021/3/12 16:46
 */
public class RandomWeight<T> {

    private final static long DEF_COUNT = 0L;

    /**
     * 权重
     */
    private List<Long> weights = new ArrayList<>();
    /**
     * 信息项
     */
    private List<T> items = new ArrayList<>();

    /**
     * 信息项的权重上限值
     */
    List<Long> limits = new ArrayList<>();
    /**
     * 信息项映射（上限值->信息项）
     */
    Map<Long, T> itemMap = new HashMap<>();
    /**
     * 最大上限值（等于所有权重的总和）
     */
    long count = DEF_COUNT;

    /**
     * 添加信息项<br/>
     *
     * @param weight 权重
     * @param item 信息项
     */
    public void addItem(Integer weight, T item){
        addItem(Long.valueOf(weight), item);
    }

    /**
     * 添加信息项<br/>
     *
     * @param weight 权重
     * @param item 信息项
     */
    public void addItem(Long weight, T item){
        assert null != weight;
        assert null != item;
        if(weight < 0){
            weight = 0L;
        }

        this.weights.add(weight);
        this.items.add(item);
        //绘制信息项上限值
        drawLimit(weight, item);
    }

    /**
     * 是否为空<br/>
     *
     * @return Boolean
     */
    public boolean isEmpty(){
        return items.isEmpty() || weights.isEmpty();
    }

    /**
     * 命中信息项<br/>
     *
     * @return 命中项
     */
    public <T> T hit(){
        if(isEmpty()){
            return null;
        }

        // 只有一个信息项
        if(items.size() == 1){
            if(weights.get(0) > 0){
                return (T) items.get(0);
            }else{
                return null;
            }
        }

        // 获取命中项
        T hitItem = null;
        //可能值：1（含）~ count（含）
        long roll = RandomUtils.nextLong(0L, count) + 1;
        for (Long limit : limits) {
            if(roll <= limit){
                hitItem = (T) itemMap.get(limit);
                break;
            }
        }
        return hitItem;
    }

    /**
     * 重置信息项上限值<br/>
     */
    private void resetLimit(){
        limits.clear();
        itemMap.clear();
        count = DEF_COUNT;

        for (int i = 0; i < weights.size(); i++) {
            Long weight = weights.get(i);
            T item = (T) items.get(i);
            //绘制信息项上限值
            drawLimit(weight, item);
        }
    }

    /**
     * 绘制信息项上限值
     */
    private void drawLimit(Long weight, T item) {
        count += weight;
        limits.add(count);
        itemMap.put(count, item);
    }
}
