package com.bxm.warcar.utils.file;

import com.bxm.warcar.utils.StringHelper;
import com.google.common.base.Preconditions;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * @author allen
 * @since 1.0.0
 */
public class SimpleFingerprintTracker implements FingerprintTracker {

    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleFingerprintTracker.class);
    private final String url;
    private final String cacheFileName;

    public SimpleFingerprintTracker(String url, String cacheFileName) {
        Preconditions.checkArgument(StringUtils.isNotBlank(url));
        Preconditions.checkArgument(StringUtils.isNotBlank(cacheFileName));
        this.url = url;
        this.cacheFileName = cacheFileName;
    }

    @Override
    public String getCacheFileName() {
        return this.cacheFileName;
    }

    @Override
    public String getFingerprint() {
        HttpURLConnection urlConnection = null;
        InputStream inputStream = null;
        try {
            urlConnection = (HttpURLConnection) new URL(url).openConnection();
            inputStream = urlConnection.getInputStream();
            byte[] buffer = new byte[inputStream.available()];
            IOUtils.readFully(inputStream, buffer);
            return StringHelper.convert(buffer);
        } catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("getFingerprint: ", e);
            }
            return null;
        } finally {
            IOUtils.closeQuietly(inputStream);
            if (null != urlConnection) {
                urlConnection.disconnect();
            }
        }
    }
}
