package com.bxm.warcar.utils.file;

import java.io.File;

/**
 * @author allen
 * @since 1.0.0
 */
public final class SystemFileComparatorFactory {

    private File fingerprint;
    private File data;
    private File license;
    private FingerprintTracker fingerprintTracker;
    private DataTracker dataTracker;
    private LicenseTracker licenseTracker;

    private SystemFileComparatorFactory() {
    }

    public static SystemFileComparatorFactory create() {
        return new SystemFileComparatorFactory();
    }

    public SystemFileComparatorFactory fingerprint(File fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    public SystemFileComparatorFactory data(File data) {
        this.data = data;
        return this;
    }
    public SystemFileComparatorFactory license(File license) {
        this.license = license;
        return this;
    }

    public SystemFileComparatorFactory fingerprintTracker(FingerprintTracker fingerprintTracker) {
        this.fingerprintTracker = fingerprintTracker;
        return this;
    }

    public SystemFileComparatorFactory dataTracker(DataTracker dataTracker) {
        this.dataTracker = dataTracker;
        return this;
    }

    public SystemFileComparatorFactory licenseTracker(LicenseTracker licenseTracker) {
        this.licenseTracker = licenseTracker;
        return this;
    }

    public SystemFileComparator build() {
        return new SystemFileComparator(fingerprint, data, license, fingerprintTracker, dataTracker, licenseTracker);
    }
}
