package com.bxm.warcar.utils.response;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;

/**
 * <p> 接口返回结果model </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/7/25
 */
public class ResponseModel<T> implements Serializable {
    private static final long serialVersionUID = 8107448352824904837L;

    /**
     * 返回结果对象
     */
    private T data;

    /**
     * 返回结果成功标志
     */
    private boolean success = true;

    /**
     * 返回结果错误标志
     */
    private boolean error = false;

    /**
     * 结果编码 0-失败，1-成功
     */
    private Integer code = 1;

    /**
     * 结果描述
     */
    private String message = "成功";

    public static <E> ResponseModel<E> newInstance() {
        return new ResponseModel<>();
    }

    private ResponseModel() {
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean isError() {
        return error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

}
