/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.localdate;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public final class LocalDateTimeHelper {
    public static final String PATTERN_STR8 = "yyyyMMdd";
    public static final String PATTERN_STR10 = "yyyy-MM-dd";
    public static final String PATTERN_STR14 = "yyyyMMddHHmmss";
    public static final String PATTERN_STR17 = "yyyyMMddHHmmssSSS";
    public static final String PATTERN_STR19 = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_STR23 = "yyyy-MM-dd HH:mm:ss.SSS";

    private LocalDateTimeHelper() {
    }

    public static String getDateStringNow() {
        return LocalDateTimeHelper.formatToString(PATTERN_STR8);
    }

    public static String formatToString(String pattern) {
        return LocalDateTimeHelper.formatToString(LocalDateTime.now(), pattern);
    }

    public static String formatToString(LocalDateTime localDateTime, String pattern) {
        return localDateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String preDateString() {
        return LocalDateTimeHelper.plusDayString(-1L, PATTERN_STR8);
    }

    public static String plusDayString(long daysToAdd, String pattern) {
        return LocalDateTimeHelper.formatToString(LocalDate.now().plusDays(daysToAdd).atTime(0, 0), pattern);
    }

    public static Date localDateTimeToDate(LocalDateTime localDateTime) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        return Date.from(zdt.toInstant());
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDateTime();
    }
}

