package com.bxm.warcar.utils.crypto;

import com.bxm.warcar.utils.StringHelper;
import org.apache.commons.codec.binary.Base64;

import java.util.function.Function;

/**
 * @author allen
 * @date 2021-08-26
 * @since 1.0
 */
public class Base64UrlSafeStringAesCipher {

    private final static StringAesCipher STRING_AES_CIPHER = StringAesCipher.builder()
            .keySerializer(new Function<String, byte[]>() {
                @Override
                public byte[] apply(String s) {
                    return StringHelper.convert(s);
                }
            })
            .contentEncryptSerializer(new Function<String, byte[]>() {
                @Override
                public byte[] apply(String s) {
                    return StringHelper.convert(s);
                }
            })
            .contentDecryptSerializer(new Function<String, byte[]>() {
                @Override
                public byte[] apply(String s) {
                    return Base64.decodeBase64(s);
                }
            })
            .contentEncryptDeserializer(new Function<byte[], String>() {
                @Override
                public String apply(byte[] bytes) {
                    return Base64.encodeBase64URLSafeString(bytes);
                }
            })
            .contentDecryptDeserializer(new Function<byte[], String>() {
                @Override
                public String apply(byte[] bytes) {
                    return StringHelper.convert(bytes);
                }
            })
            .build();

    private Base64UrlSafeStringAesCipher() {}

    public static String encrypt(String key, String content) throws Exception {
        return STRING_AES_CIPHER.encrypt(key, content);
    }

    public static String decrypt(String key, String content) throws Exception {
        return STRING_AES_CIPHER.decrypt(key, content);
    }
}
