/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;

public class BeanHelper {
    public static <T> void checkList(ApplicationContext applicationContext, Class<T> clazz, List<T> builders) {
        Map beans = applicationContext.getBeansOfType(clazz);
        Set loaded = builders.stream().map(BeanHelper::getClassName).collect(Collectors.toSet());
        Optional<Object> noload = beans.values().stream().filter(e -> !loaded.contains(BeanHelper.getClassName(e))).findFirst();
        if (noload.isPresent()) {
            throw new RuntimeException("Bean [" + noload.get() + "] already registered to Spring, but no add into builder List!");
        }
    }

    private static String getClassName(Object bean) {
        return ClassUtils.getUserClass((Object)bean).getName();
    }
}

