/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;

public final class ReflectUtils {
    private ReflectUtils() {
    }

    public static final void setDynaBean2Request(Object request, Object dynaBean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> clazz = request.getClass();
        do {
            Field[] fields;
            for (Field f : fields = clazz.getDeclaredFields()) {
                String f_name = f.getName();
                if ("serialVersionUID".equals(f_name)) continue;
                String f_value = BeanUtils.getProperty((Object)dynaBean, (String)f_name);
                BeanUtils.setProperty((Object)request, (String)f_name, (Object)f_value);
            }
        } while (!(clazz = clazz.getSuperclass()).getSimpleName().equals("BaseRequest"));
    }

    public static Field findField(Class<?> clazz, String fieldName) {
        if (null == clazz || null == fieldName || fieldName.equals("")) {
            throw new IllegalArgumentException();
        }
        while (true) {
            try {
                Field f = clazz.getDeclaredField(fieldName);
                return f;
            }
            catch (SecurityException e) {
                return null;
            }
            catch (NoSuchFieldException e) {
                if (!(clazz = clazz.getSuperclass()).equals(Object.class)) continue;
                return null;
            }
            break;
        }
    }

    public static Field[] findAllFields(Class<?> clazz) {
        return ReflectUtils.findFields(clazz, null);
    }

    public static Field[] findFields(Class<?> clazz, FieldFilter fieldFilter) {
        Field[] result = new Field[]{};
        do {
            Field[] fs = clazz.getDeclaredFields();
            if (null != fieldFilter) {
                ArrayList<Field> list_fs = new ArrayList<Field>();
                for (Field f : fs) {
                    if (!fieldFilter.accept(f)) continue;
                    list_fs.add(f);
                }
                fs = list_fs.toArray(new Field[0]);
            }
            Field[] tmp = new Field[result.length + fs.length];
            System.arraycopy(result, 0, tmp, 0, result.length);
            System.arraycopy(fs, 0, tmp, result.length, fs.length);
            result = tmp;
        } while (!(clazz = clazz.getSuperclass()).equals(Object.class));
        return result;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationClass) {
        if (null == clazz || null == annotationClass) {
            throw new NullPointerException();
        }
        do {
            T anno;
            if (null == (anno = clazz.getAnnotation(annotationClass))) continue;
            return anno;
        } while (!(clazz = clazz.getSuperclass()).equals(Object.class));
        return null;
    }

    public static <T extends Annotation> List<T> getAnnotations(Class<?> clazz, Class<T> annotationClass) {
        if (null == clazz || null == annotationClass) {
            throw new NullPointerException();
        }
        ArrayList ret = Lists.newArrayList();
        do {
            T anno;
            if (null == (anno = clazz.getAnnotation(annotationClass))) continue;
            ret.add(anno);
        } while (!(clazz = clazz.getSuperclass()).equals(Object.class));
        return ret;
    }

    public static List<Method> findMethods(Class<?> clazz, MethodFilter methodFilter) {
        if (null == clazz) {
            throw new NullPointerException("clazz");
        }
        if (null == methodFilter) {
            methodFilter = MethodFilter.DEFAULT;
        }
        ArrayList ret = Lists.newArrayList();
        do {
            Method[] ms;
            for (Method m : ms = clazz.getDeclaredMethods()) {
                if (!methodFilter.accept(m)) continue;
                ret.add(m);
            }
        } while (!(clazz = clazz.getSuperclass()).equals(Object.class));
        return ret;
    }

    public static void main(String[] args) {
        try {
            Enumeration<URL> urls = ReflectUtils.class.getClassLoader().getResources("com/channel/utils");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                System.out.println(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class C
    extends B {
        private String c;

        private C() {
        }

        public String getC() {
            return this.c;
        }

        public void setC(String c) {
            this.c = c;
        }
    }

    private static class B
    extends A {
        private String b;

        private B() {
        }

        public String getB() {
            return this.b;
        }

        public void setB(String b) {
            this.b = b;
        }
    }

    private static class A {
        private String a;

        private A() {
        }

        public String getA() {
            return this.a;
        }

        public void setA(String a) {
            this.a = a;
        }
    }

    public static interface MethodFilter {
        public static final MethodFilter DEFAULT = new MethodFilter(){

            @Override
            public boolean accept(Method method) {
                return true;
            }
        };

        public boolean accept(Method var1);
    }

    public static interface FieldFilter {
        public boolean accept(Field var1);
    }
}

