package com.bxm.warcar.utils.file;

import java.io.File;
import java.io.IOException;

/**
 * 文件比较器
 * @author allen
 * @since 1.0.0
 */
public interface FileComparator {

    /**
     * 文件比较。
     * 如果文件指纹不一致，那么将从 DataTracker 中获取文件，并更新指纹。
     *
     * @return 如果双方的文件指纹一致，那么返回 true，否则返回 false
     * @throws IOException IO Exception
     */
    boolean compare() throws IOException;

    /**
     * 获取数据文件
     *
     * @return 数据文件
     */
    File getData();

    /**
     * 获取指纹文件
     *
     * @return 指纹文件
     */
    File getFingerprint();

    /**
     * 获取 License 文件
     * @return License 文件
     */
    File getLicense();
}
