package com.bxm.warcar.utils;

import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

/**
 * <h3>集合内容比较比较</h3>
 * <p>支持 string short byte char integer int long float  boolean  double date  timestamp  bigdecimal 等类型</p>
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/29 14:02
 */
public class ListOrderHelper {

    private static final int        DEFULT_ZERO = 0;
    private static final int        DEFULT_TWO  = 2;
    private static final String     ASC         = "ASC" ;
    private static final String     STRING      = "string";
    private static final String     SHORT       = "short";
    private static final String     BYTE        = "byte";
    private static final String     CHAR        = "char";
    private static final String     INTEGER     = "integer";
    private static final String     INT         = "int";
    private static final String     LONG        = "long";
    private static final String     FLOAT       = "float";
    private static final String     DOUBLE      = "double";
    private static final String     BOOLEAN     = "boolean";
    private static final String     DATE        = "date";
    private static final String     TIMESTAMP   = "timestamp";
    private static final String     COMPARETO   = "compareTo";
    private static final String     BIGDECIMAL  = "bigdecimal";


    /** 
     * 对List对象按照某个成员变量进行排序 
     * @param list       List对象 
     * @param sortField  排序的属性名称 
     * @param sortMode   排序方式：ASC，DESC 任选其一 
     */  
    public static <T> void sortList(List<T> list, final String sortField, final String sortMode) {  
        if(list == null || list.size() < DEFULT_TWO) {
            return;  
        }  
        Collections.sort(list, new Comparator<T>() {  
            @Override  
            public int compare(T o1, T o2) {  
                try {  
                    Class<? extends Object> clazz = o1.getClass();  
                    Field field = clazz.getDeclaredField(sortField); //获取成员变量  
                    field.setAccessible(true); //设置成可访问状态  
                    String typeName = field.getType().getName().toLowerCase(); //转换成小写  
      
                    Object v1 = field.get(o1); //获取field的值
                    Object v2 = field.get(o2); //获取field的值

                    if(typeName.endsWith(DOUBLE)
                            ||typeName.endsWith(SHORT)
                            ||typeName.endsWith(LONG)
                            ||typeName.endsWith(INT)
                            ||typeName.endsWith(INTEGER)
                            ||typeName.endsWith(BIGDECIMAL)){
                        v1 = null ==v1?0:v1;
                        v2 = null ==v2?0:v2;
                    }
                    if(null==v1||null==v2){
                        return DEFULT_ZERO;
                    }
                    boolean ASC_order = (sortMode == null || ASC.equalsIgnoreCase(sortMode));
      
                    //判断字段数据类型，并比较大小  
                    if(typeName.endsWith(STRING)) {
                        String value1 = v1.toString();  
                        String value2 = v2.toString();
                        if(StringUtils.isNumericSpace(value1.replace(".","").replace("%",""))
                                && StringUtils.isNumericSpace(value2.replace(".","").replace("%",""))){
                            Double doublevalue1 = Double.parseDouble(v1.toString().replace("%",""));
                            Double doublevalue2 = Double.parseDouble(v2.toString().replace("%",""));
                            return ASC_order ? doublevalue1.compareTo(doublevalue2) : doublevalue2.compareTo(doublevalue1);
                        }
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);  
                    }  
                    else if(typeName.endsWith(SHORT)) {
                        Short value1 = Short.parseShort(v1.toString());  
                        Short value2 = Short.parseShort(v2.toString());  
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);  
                    }  
                    else if(typeName.endsWith(BYTE)) {
                        Byte value1 = Byte.parseByte(v1.toString());  
                        Byte value2 = Byte.parseByte(v2.toString());  
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);  
                    }  
                    else if(typeName.endsWith(CHAR)) {
                        Integer value1 = (int)(v1.toString().charAt(DEFULT_ZERO));
                        Integer value2 = (int)(v2.toString().charAt(DEFULT_ZERO));
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);  
                    }  
                    else if(typeName.endsWith(INT) || typeName.endsWith(INTEGER)) {
                        Integer value1 = Integer.parseInt(v1.toString());  
                        Integer value2 = Integer.parseInt(v2.toString());  
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);  
                    }  
                    else if(typeName.endsWith(LONG)) {
                        Long value1 = Long.parseLong(v1.toString());  
                        Long value2 = Long.parseLong(v2.toString());  
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);  
                    }  
                    else if(typeName.endsWith(FLOAT)) {
                        Float value1 = Float.parseFloat(v1.toString());  
                        Float value2 = Float.parseFloat(v2.toString());  
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);  
                    }  
                    else if(typeName.endsWith(DOUBLE)) {
                        Double value1 = Double.parseDouble(v1.toString());  
                        Double value2 = Double.parseDouble(v2.toString());  
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);  
                    }  
                    else if(typeName.endsWith(BOOLEAN)) {
                        Boolean value1 = Boolean.parseBoolean(v1.toString());  
                        Boolean value2 = Boolean.parseBoolean(v2.toString());  
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);  
                    }
                    else if(typeName.endsWith(DATE)) {
                        Date value1 = (Date)(v1);  
                        Date value2 = (Date)(v2);  
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);  
                    }  
                    else if(typeName.endsWith(TIMESTAMP)) {
                        Timestamp value1 = (Timestamp)(v1);  
                        Timestamp value2 = (Timestamp)(v2);  
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);  
                    }
                    else if(typeName.endsWith(BIGDECIMAL)) {
                        BigDecimal value1 = new BigDecimal(v1.toString());
                        BigDecimal value2 = new BigDecimal(v2.toString());
                        return ASC_order ? value1.compareTo(value2) : value2.compareTo(value1);
                    }
                    else {  
                        //调用对象的compareTo()方法比较大小  
                        Method method = field.getType().getDeclaredMethod(COMPARETO, new Class[]{field.getType()});
                        method.setAccessible(true); //设置可访问权限  
                        int result  = (Integer)method.invoke(v1, new Object[]{v2});  
                        return ASC_order ? result : result*(-1);  
                    }  
                }
                catch (Exception e) {
                    e.printStackTrace();  
                }
                return DEFULT_ZERO; //未知类型，无法比较大小
            }  
        });  
    }

}
