package com.bxm.warcar.utils;

import java.util.regex.Pattern;

/**
 * 移动设备帮助类<br/>
 *
 * @author kerry.jiang
 * @date 2019/11/26 16:36
 */
public class MobileHelper {

    /**
     * IMEI
     */
    private final static Pattern PATTERN_IMEI = Pattern.compile("\\d{12,}");
    /**
     * IDFA
     */
    private final static Pattern PATTERN_IDFA = Pattern.compile("^([0-9a-zA-Z]{1,})(([/\\s-][0-9a-zA-Z]{1,}){4})$");
    /**
     * MAC
     */
    private final static Pattern PATTERN_MAC = Pattern.compile("^([0-9a-fA-F]{2})(([:][0-9a-fA-F]{2}){5})$");

    /**
     * 粗略判断是否是真实IMEI<br/>
     *
     * @param imei
     * @return
     */
    public static boolean isImei(String imei){
        if(null == imei){
            return Boolean.FALSE;
        }
        return PATTERN_IMEI.matcher(imei).find();
    }

    /**
     * 粗略判断是否是真实IDFA<br/>
     *
     * @param idfa
     * @return
     */
    public static boolean isIdfa(String idfa){
        if(null == idfa){
            return Boolean.FALSE;
        }
        return PATTERN_IDFA.matcher(idfa).find();
    }

    /**
     * 粗略判断是否是真实MAC<br/>
     *
     * @param mac
     * @return
     */
    public static boolean isMac(String mac){
        if(null == mac){
            return Boolean.FALSE;
        }
        return PATTERN_MAC.matcher(mac).find();
    }

    public static void main(String[] args) {
        System.out.println(isImei("351710058880864"));
        System.out.println(isIdfa("4E21D3AB-0D67-4903-9734-C98804407274"));
        System.out.println(isMac("44:2A:60:71:CC:82"));
    }
}
