package com.bxm.warcar.utils;

import org.apache.commons.lang.StringUtils;

import java.net.URI;

/**
 * <h3>Utils for path/url/uri</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/15
 */
public final class PathUtils {

    private PathUtils() {}

    public static String appendToHost(String host, Object...uris) {
        StringBuilder stringBuilder = new StringBuilder(host);
        for (Object s : uris) {
            if (! StringUtils.endsWith(stringBuilder.toString(), "/")) {
                stringBuilder.append("/").append(s);
            }
            else {
                stringBuilder.append(s);
            }
        }
        return stringBuilder.toString();
    }

    public static String replaceDomain(String url, String domain) {
        if (StringUtils.isBlank(url)) {
            return url;
        }
        URI uri;
        try {
            uri = URI.create(url);
        } catch (Exception e) {
            return url;
        }
        if (StringUtils.isBlank(uri.getScheme())) {
            return url;
        }

        StringBuilder s = new StringBuilder(url.length());
        s.append(uri.getScheme());
        s.append("://");
        s.append(domain);

        if (uri.getPort() > 0) {
            s.append(":");
            s.append(String.valueOf(uri.getPort()));
        }
        s.append(uri.getPath());

        if (StringUtils.isNotBlank(uri.getQuery())) {
            s.append("?");
            s.append(uri.getQuery());
        }
        if (StringUtils.isNotBlank(uri.getFragment())) {
            s.append("#");
            s.append(uri.getFragment());
        }
        return s.toString();
    }

    public static void main(String[] args) {
        System.out.println(replaceDomain("ss/", "i.tandehao.com"));
        System.out.println(replaceDomain("http://baidu.com/", "i.tandehao.com"));
        System.out.println(replaceDomain("https://m.cudaojia.com/dist/ACTIVITY/prize/2018/04/20/c78d3197-861d-45cc-a963-440df29da00e", "m.tandehao.com"));
        System.out.println(replaceDomain("https://m.cudaojia.com/dist/welfareAT02/private/C/CustService/index.js?v=1219&reVersion=5160247", "m.tandehao.com"));
        System.out.println(replaceDomain("https://m.cudaojia.com/dist/welfareAT02/public/lib/common/extend.css", "m.tandehao.com"));
        System.out.println(replaceDomain("https://m.cudaojia.com/dist/welfareAT02/private/T/T098/bundle0104A.css?80063225b4053272d1bc", "m.tandehao.com"));
        System.out.println(replaceDomain("ftp://m.cudaojia.com/dist/welfareAT02/private/T/", "m.tandehao.com"));
        System.out.println(replaceDomain("http://m.cudaojia.com/dist/welfareAT02/private/T/T098/index.html?business=money-6", "m.tandehao.com"));
        System.out.println(replaceDomain("http://m.cudaojia.com/dist/welfareAT02/private/T/T098/index.html?business=money-6#backup=1", "m.tandehao.com"));
        System.out.println(replaceDomain("http://m.cudaojia.com/dist/welfareAT02/private/T/T098/index.html?business=money-6&uri=http://www.baidu.com", "m.tandehao.com"));
        System.out.println(replaceDomain("https://m.cudaojia.com/dist/welfareAT02/private/T/T098/index.html?business=money-6&appkey=205f1651893749f3940fe07803e3a3a0&uid=1484E7216854A5501D0E2A63596A5C1B&activityid=13174&spm=lti.2019012120222662302996254681#", "m.tandehao.com"));
    }
}
