/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.http;

import com.alibaba.fastjson.JSON;
import com.bxm.warcar.utils.http.HttpMethod;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class OkHttpUtils {
    private static OkHttpClient mOkHttpClient = new OkHttpClient.Builder().build();

    public static String get(String url) throws IOException {
        return OkHttpUtils.packagingResult(OkHttpUtils.getRequest(url));
    }

    public static String get(String url, Map<String, String> headers) throws IOException {
        return OkHttpUtils.packagingResult(OkHttpUtils.request(url, HttpMethod.GET, headers));
    }

    public static String get(String url, Map<String, Object> params, Map<String, String> headers) throws IOException {
        return OkHttpUtils.get(OkHttpUtils.appendParams(url, params), headers);
    }

    public String post(String url) throws IOException {
        return OkHttpUtils.post(url, Maps.newHashMap());
    }

    public static String post(String url, Map<String, Object> params) throws IOException {
        return OkHttpUtils.packagingResult(OkHttpUtils.postRequest(url, OkHttpUtils.buildBody(params)));
    }

    public static String post(String url, Map<String, Object> params, Map<String, String> headers) throws IOException {
        return OkHttpUtils.packagingResult(OkHttpUtils.request(url, HttpMethod.POST, OkHttpUtils.buildBody(params), headers));
    }

    public static String postRequestBody(String url, Object o, Map<String, String> headers) throws IOException {
        return OkHttpUtils.packagingResult(OkHttpUtils.requestBody(url, HttpMethod.POST, OkHttpUtils.buildRequestBody(o), headers));
    }

    public static Response post(String url, Object o) throws IOException {
        return OkHttpUtils.postRequest(url, OkHttpUtils.buildRequestBody(o));
    }

    public static Response postRequest(String url, RequestBody body) throws IOException {
        return OkHttpUtils.request(url, HttpMethod.POST, body);
    }

    private static Response getRequest(String url) throws IOException {
        return OkHttpUtils.request(url, HttpMethod.GET);
    }

    public static Response request(String url, HttpMethod method) throws IOException {
        return OkHttpUtils.request(url, method, Maps.newHashMap());
    }

    public static Response request(String url, HttpMethod method, Map<String, String> headers) throws IOException {
        return OkHttpUtils.request(url, method, null, headers);
    }

    public static Response request(String url, HttpMethod method, RequestBody body) throws IOException {
        return OkHttpUtils.request(url, method, body, null);
    }

    public static Response request(String url, HttpMethod method, RequestBody body, Map<String, String> headers) throws IOException {
        return mOkHttpClient.newCall(OkHttpUtils.setHeaders(OkHttpUtils.buildRequest(url, method, body), headers).build()).execute();
    }

    public static Response requestBody(String url, HttpMethod method, RequestBody body, Map<String, String> headers) throws IOException {
        return mOkHttpClient.newCall(OkHttpUtils.setHeaders(OkHttpUtils.buildRequest(url, method, body), headers).build()).execute();
    }

    public static Request.Builder buildRequest(String url, HttpMethod httpMethod, RequestBody body) {
        if (httpMethod == null) {
            httpMethod = HttpMethod.GET;
        }
        switch (httpMethod) {
            case GET: {
                return new Request.Builder().url(url).get();
            }
            case POST: {
                return new Request.Builder().url(url).post(body);
            }
            case PUT: {
                return new Request.Builder().url(url).put(body);
            }
            case PATCH: {
                return new Request.Builder().url(url).patch(body);
            }
            case DELETE: {
                return new Request.Builder().url(url).delete(body);
            }
        }
        return new Request.Builder().url(url).get();
    }

    public static String packagingResult(Response response) throws IOException {
        if (response != null && response.body() != null) {
            return response.body().string();
        }
        return null;
    }

    public static Request.Builder setHeaders(Request.Builder builder, Map<String, String> headers) {
        if (MapUtils.isEmpty(headers)) {
            return builder;
        }
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).header(arg_0, arg_1));
        return builder;
    }

    public static String appendParams(String url, Map<String, Object> params) {
        if (MapUtils.isEmpty(params)) {
            return url;
        }
        StringBuffer psb = new StringBuffer();
        params.forEach((key, value) -> {
            try {
                if (key == null) {
                    return;
                }
                psb.append(URLEncoder.encode(key, "UTF-8")).append("=");
                if (value != null) {
                    psb.append(URLEncoder.encode(value.toString(), "UTF-8"));
                }
                psb.append("&");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        });
        if (url.indexOf("?") > 0) {
            return url + "&" + StringUtils.removeEnd((String)psb.toString(), (String)"&");
        }
        return url + "?" + StringUtils.removeEnd((String)psb.toString(), (String)"&");
    }

    public static RequestBody buildBody(Map<String, Object> params) throws IOException {
        FormBody.Builder build = new FormBody.Builder();
        if (MapUtils.isNotEmpty(params)) {
            for (String key : params.keySet()) {
                if (params.get(key) == null) continue;
                build.add(URLEncoder.encode(key, "UTF-8"), URLEncoder.encode(params.get(key).toString(), "UTF-8"));
            }
        }
        return build.build();
    }

    public static RequestBody buildRequestBody(Object o) {
        if (null == o) {
            throw new NullPointerException("okhttp request body is null");
        }
        return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)JSON.toJSONString((Object)o));
    }
}

