/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;

public final class DateHelper {
    public static final long SECONDS_OF_DAY = 86400L;
    public static final String PATTERN_STR8 = "yyyyMMdd";
    public static final String PATTERN_STR10 = "yyyy-MM-dd";
    public static final String PATTERN_STR14 = "yyyyMMddHHmmss";
    public static final String PATTERN_STR19 = "yyyy-MM-dd HH:mm:ss";

    private DateHelper() {
    }

    public static long getRemainSecondsOfToday() {
        return DateHelper.getRemainSecondsOfDay(1);
    }

    public static long getRemainSecondsOfDay(int day) {
        return 86400L * (long)day - DateUtils.getFragmentInSeconds((Calendar)Calendar.getInstance(), (int)5);
    }

    public static String getDate() {
        return DateHelper.format(PATTERN_STR8);
    }

    public static String format(String pattern) {
        return DateFormatUtils.format((Calendar)Calendar.getInstance(), (String)pattern);
    }

    public static String format(Date date, String pattern) {
        return DateFormatUtils.format((Date)date, (String)pattern);
    }

    public static Date parse(String date, String pattern) {
        try {
            return DateUtils.parseDate((String)date, (String[])new String[]{pattern});
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getPreDate(String date) throws ParseException {
        return DateHelper.getDate(date, -1);
    }

    public static String getNextDate(String date) throws ParseException {
        return DateHelper.getDate(date, 1);
    }

    public static String getDate(String date, int count) throws ParseException {
        return DateHelper.getDate(date, count, PATTERN_STR10);
    }

    public static String getDate(String date, int count, String pattern) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat parser = new SimpleDateFormat(pattern);
        calendar.setTime(parser.parse(date));
        calendar.add(5, count);
        return parser.format(calendar.getTime());
    }

    public static String getDateFromToday(int count, String pattern) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, count);
        return DateFormatUtils.format((Date)calendar.getTime(), (String)pattern);
    }

    public static Date convertStringToDate(String strDate, String pattern) {
        if (StringUtils.isBlank((CharSequence)strDate) || StringUtils.isBlank((CharSequence)pattern)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String convertDateToString(Date date) {
        return DateHelper.convertDateToString(date, PATTERN_STR19);
    }

    public static String convertDateToString(Date date, String pattern) {
        if (date == null || StringUtils.isBlank((CharSequence)pattern)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

