/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils;

import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class IpHelper {
    private static final String LOCALHOST_IP6 = "0:0:0:0:0:0:0:1";
    private static final String LOCALHOST_IP4 = "127.0.0.1";

    public static String getIpFromHeader(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        String ip = request.getHeader("X-Forwarded-For");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ip) && !"unknown".equalsIgnoreCase(ip)) {
            return ip.indexOf(44) == -1 ? ip : ip.substring(0, ip.indexOf(44));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return LOCALHOST_IP6.equals(ip) ? LOCALHOST_IP4 : ip;
    }

    public static String getIpNoDotTwo(String ip) {
        if (StringUtils.isBlank((String)ip)) {
            return "0";
        }
        String[] ips = ip.split("\\.");
        if (ips.length != 4) {
            return "0";
        }
        return ips[0] + ips[1];
    }

    public static String getIpNoDot(String ip) {
        if (StringUtils.isBlank((String)ip)) {
            return "0";
        }
        String[] ips = ip.split("\\.");
        if (ips.length != 4) {
            return "0";
        }
        return ip.replace(".", "");
    }

    public static int getIntIp(String ip) {
        if (StringUtils.isBlank((String)ip)) {
            return 0;
        }
        String[] ips = ip.split("\\.");
        if (ips.length != 4) {
            return 0;
        }
        return (Integer.parseInt(ips[0]) << 24) + (Integer.parseInt(ips[1]) << 16) + (Integer.parseInt(ips[2]) << 8) + Integer.parseInt(ips[3]);
    }

    public static String getStringIp(int intIp) {
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(intIp >>> 24));
        sb.append(".");
        sb.append(String.valueOf((intIp & 0xFFFFFF) >>> 16));
        sb.append(".");
        sb.append(String.valueOf((intIp & 0xFFFF) >>> 8));
        sb.append(".");
        sb.append(String.valueOf(intIp & 0xFF));
        return sb.toString();
    }

    public static String generate() {
        int[][] range = new int[][]{{607649792, 608174079}, {1038614528, 1039007743}, {1783627776, 1784676351}, {2035023872, 2035154943}, {2078801920, 2079064063}, {-1950089216, -1948778497}, {-1425539072, -1425014785}, {-1236271104, -1235419137}, {-770113536, -768606209}, {-569376768, -564133889}};
        Random rdint = new Random();
        int index = rdint.nextInt(10);
        return IpHelper.num2ip(range[index][0] + new Random().nextInt(range[index][1] - range[index][0]));
    }

    public static String num2ip(int ip) {
        int[] b = new int[4];
        String x = "";
        b[0] = ip >> 24 & 0xFF;
        b[1] = ip >> 16 & 0xFF;
        b[2] = ip >> 8 & 0xFF;
        b[3] = ip & 0xFF;
        x = Integer.toString(b[0]) + "." + Integer.toString(b[1]) + "." + Integer.toString(b[2]) + "." + Integer.toString(b[3]);
        return x;
    }
}

