/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.lang.text.StrSubstitutor;

public class StringHelper
extends StringUtils {
    public static final char[] CODE_ARRAY = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public static String random(char[] scope, int len) {
        if (ArrayUtils.isEmpty((char[])scope)) {
            scope = CODE_ARRAY;
        }
        StringBuilder str = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            str.append(scope[RandomUtils.nextInt((int)scope.length)]);
        }
        return str.toString();
    }

    public static String random(int len) {
        return StringHelper.random(CODE_ARRAY, len);
    }

    public static String uuid() {
        return UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
    }

    public static String randomInt(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(RandomUtils.nextInt((int)10));
        }
        return sb.toString();
    }

    public static String convert(byte[] b) {
        if (ArrayUtils.isEmpty((byte[])b)) {
            return null;
        }
        return new String(b, StandardCharsets.UTF_8);
    }

    public static byte[] convert(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static String unicode2native(String str) {
        int len = str.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = str.charAt(x++)) == 92) {
                if ((aChar = str.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = str.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed   \\uxxxx   encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    public static List<String> replaceHolder(String prefix, String suffix, Map valueMap, List<String> sources) {
        if (CollectionUtils.isEmpty(sources)) {
            return null;
        }
        StringHelper.validation(valueMap);
        StrSubstitutor substitutor = new StrSubstitutor(valueMap, prefix, suffix);
        ArrayList<String> respList = new ArrayList<String>();
        for (String source : sources) {
            if (StringUtils.isBlank((String)source)) continue;
            respList.add(substitutor.replace(source));
        }
        return respList;
    }

    public static List<String> replaceHolder(String prefix, String suffix, Map valueMap, String ... sources) {
        if (null == sources || sources.length < 1) {
            return null;
        }
        StringHelper.validation(valueMap);
        StrSubstitutor substitutor = new StrSubstitutor(valueMap, prefix, suffix);
        ArrayList<String> respList = new ArrayList<String>();
        for (String source : sources) {
            if (StringUtils.isBlank((String)source)) continue;
            respList.add(substitutor.replace(source));
        }
        return respList;
    }

    public static String replaceHolder(String prefix, String suffix, Map valueMap, String source) {
        if (StringUtils.isBlank((String)source)) {
            return null;
        }
        StringHelper.validation(valueMap);
        StrSubstitutor substitutor = new StrSubstitutor(valueMap, prefix, suffix);
        return substitutor.replace(source);
    }

    private static void validation(Map valueMap) {
        valueMap.forEach((k, v) -> {
            if (null == v) {
                valueMap.put(k, "");
            }
        });
    }

    public static boolean isNewVersion(String standard_version, String online_version) {
        String[] onlineArray;
        if (StringUtils.isEmpty((String)online_version)) {
            return Boolean.FALSE;
        }
        if (StringUtils.isEmpty((String)standard_version) || standard_version.equals(online_version)) {
            return Boolean.TRUE;
        }
        String[] standardArray = standard_version.replaceAll("[^0-9.]", "").split("[.]");
        int length = standardArray.length < (onlineArray = online_version.replaceAll("[^0-9.]", "").split("[.]")).length ? standardArray.length : onlineArray.length;
        for (int i = 0; i < length; ++i) {
            if (StringUtils.isEmpty((String)onlineArray[i])) {
                return Boolean.FALSE;
            }
            if (StringUtils.isEmpty((String)standardArray[i])) {
                return Boolean.TRUE;
            }
            if (Integer.parseInt(onlineArray[i]) > Integer.parseInt(standardArray[i])) {
                return Boolean.TRUE;
            }
            if (Integer.parseInt(onlineArray[i]) >= Integer.parseInt(standardArray[i])) continue;
            return Boolean.FALSE;
        }
        return onlineArray.length > standardArray.length;
    }
}

