/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.crypto;

import com.bxm.warcar.utils.StringHelper;
import com.bxm.warcar.utils.crypto.StringAesCipher;
import java.util.function.Function;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class HexAesCipher {
    private static final StringAesCipher STRING_AES_CIPHER = StringAesCipher.builder().keySerializer(new Function<String, byte[]>(){

        @Override
        public byte[] apply(String s) {
            return StringHelper.convert(s);
        }
    }).contentEncryptSerializer(new Function<String, byte[]>(){

        @Override
        public byte[] apply(String s) {
            return StringHelper.convert(s);
        }
    }).contentDecryptSerializer(new Function<String, byte[]>(){

        @Override
        public byte[] apply(String s) {
            try {
                return Hex.decodeHex((String)s);
            }
            catch (DecoderException e) {
                throw new RuntimeException(e);
            }
        }
    }).contentEncryptDeserializer(new Function<byte[], String>(){

        @Override
        public String apply(byte[] bytes) {
            return Hex.encodeHexString((byte[])bytes);
        }
    }).contentDecryptDeserializer(new Function<byte[], String>(){

        @Override
        public String apply(byte[] bytes) {
            return StringHelper.convert(bytes);
        }
    }).build();

    private HexAesCipher() {
    }

    public static String encrypt(String key, String content) throws Exception {
        return STRING_AES_CIPHER.encrypt(key, content);
    }

    public static String decrypt(String key, String content) throws Exception {
        return STRING_AES_CIPHER.decrypt(key, content);
    }
}

