/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.validate.internal;

import com.bxm.warcar.validate.AbstractValidator;
import com.bxm.warcar.validate.ConstraintViolationException;
import com.bxm.warcar.validate.ValidateException;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PatternValidator
extends AbstractValidator {
    private final Pattern pattern;

    public PatternValidator(Field field, String regex) {
        super(field);
        if (StringUtils.isBlank((String)regex)) {
            throw new IllegalArgumentException("regex is blank.");
        }
        this.pattern = Pattern.compile(regex);
    }

    @Override
    protected void doValidate(Object input) throws Exception {
        Object _v = this.getValue(input);
        String defaultValue = this.getDefaultValue();
        if (!(_v instanceof String)) {
            throw new ValidateException("Expect String,but " + _v);
        }
        String v = (String)_v;
        Matcher m = this.pattern.matcher(v);
        if (!m.matches()) {
            if (defaultValue != null) {
                this.setValue(input, defaultValue);
            } else {
                throw new ConstraintViolationException(this, v);
            }
        }
    }

    @Override
    public String getConstraintDesc() {
        return this.getFieldDesc() + " match Pattern:" + this.pattern;
    }
}

