/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.validate.internal;


import com.bxm.warcar.validate.AbstractValidator;
import com.bxm.warcar.validate.ConstraintViolationException;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

/**
 * 非空校验器
 */
public class NotNullValidator extends AbstractValidator {

	public NotNullValidator(Field field) {
		super(field);
	}

	public NotNullValidator(Field field, String value) {
		super(field, value);
	}

	/**
	 * 非空校验中添加默认值的赋值
	 *
	 * @param input
	 * @return void
	 * @throws
	 * @author kk.xie
	 * @date 2018/7/26 12:01
	 */
	@Override
	protected void doValidate(Object input) throws Exception {
		String defaultValue = getDefaultValue();
		Object v = getValue(input);
		if (null == v) {
			if (defaultValue != null) {
				setValue(input, defaultValue);
			} else {
				throw new ConstraintViolationException(this);
			}
		}
	}

	@Override
	public String getConstraintDesc() {
		return getFieldDesc() + " must not be allow null.";
	}
}
