/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.validate.internal;


import com.bxm.warcar.validate.ConstraintViolationException;
import com.bxm.warcar.validate.ValidateException;
import com.bxm.warcar.validate.Validator;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;


public class BeanValidator implements Validator {

	private final List<Validator> elementValidator = new CopyOnWriteArrayList<Validator>();

	@Override
	public void validate(Object input) throws ValidateException, ConstraintViolationException {
		if (null == input)
			throw new NullPointerException("input");
		for (Validator ev : elementValidator)
			ev.validate(input);
	}

	@Override
	public String getConstraintDesc() {
		return "Bean Validator";
	}

	@Override
	public String toString() {
		return "Bean Validator";
	}

	public void register(List<Validator> validators) {
		if (null == validators)
			throw new NullPointerException("validators");
		for (Validator v : validators)
			register(v);
	}

	public void register(Validator validator) {
		if (null == validator)
			throw new NullPointerException("validator");
		elementValidator.add(validator);
	}

	public void clear() {
		elementValidator.clear();
	}
}
