/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.validate.internal;

import com.bxm.warcar.validate.AbstractValidator;
import com.bxm.warcar.validate.ConstraintViolationException;
import com.bxm.warcar.validate.NoopValidator;
import com.bxm.warcar.validate.ValidateException;
import com.bxm.warcar.validate.Validator;
import java.lang.reflect.Field;
import java.util.Collection;

public class CollectionValidator
extends AbstractValidator {
    private static final Validator DEFAULT_ELEMENT_VALIDATOR = new NoopValidator();
    private static final boolean DEFAULT_ALLOW_EMPTY = true;
    private static final int DEFAULT_MIN_SIZE = 0;
    private static final int DEFAULT_MAX_SIZE = Integer.MAX_VALUE;
    private final boolean allowEmpty;
    private final int minSize;
    private final int maxSize;
    private final Validator elementValidator;

    public CollectionValidator(Field field, Validator elementValidator) {
        this(field, elementValidator, true, 0, Integer.MAX_VALUE);
    }

    public CollectionValidator(Field field, boolean allowEmpty, int minSize, int maxSize) {
        this(field, DEFAULT_ELEMENT_VALIDATOR, allowEmpty, minSize, maxSize);
    }

    public CollectionValidator(Field field, Validator elementValidator, boolean allowEmpty, int minSize, int maxSize) {
        super(field);
        if (null == elementValidator) {
            throw new NullPointerException("elementValidator");
        }
        if (minSize < 0) {
            throw new IllegalArgumentException("minSize:" + minSize);
        }
        if (minSize > maxSize) {
            throw new IllegalArgumentException("minSize:" + minSize + " maxSize:" + maxSize);
        }
        this.elementValidator = elementValidator;
        this.allowEmpty = allowEmpty;
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    @Override
    protected void doValidate(Object input) throws Exception {
        Class<?> fieldType = this.getField().getType();
        if (this.isCollection(fieldType)) {
            Collection collection = (Collection)this.getValue(input);
            if (null == collection || 0 == collection.size()) {
                if (!this.allowEmpty) {
                    throw new ConstraintViolationException(this);
                }
            } else {
                int l = collection.size();
                if (l < this.minSize || l > this.maxSize) {
                    throw new ConstraintViolationException(this, "size:" + l);
                }
            }
            this.validateElement(collection);
        } else if (this.isArray(fieldType)) {
            Object[] collection = (Object[])this.getValue(input);
            if (null == collection || 0 == collection.length) {
                if (!this.allowEmpty) {
                    throw new ConstraintViolationException(this);
                }
            } else {
                int l = collection.length;
                if (l < this.minSize || l > this.maxSize) {
                    throw new ConstraintViolationException(this, "size:" + l);
                }
            }
            this.validateElement(collection);
        } else {
            throw new ValidateException("Unkown input:" + input);
        }
    }

    private void validateElement(Object[] collection) {
        if (this.elementValidator instanceof NoopValidator) {
            return;
        }
        for (Object element : collection) {
            this.elementValidator.validate(element);
        }
    }

    private void validateElement(Iterable<?> collection) {
        if (this.elementValidator instanceof NoopValidator) {
            return;
        }
        for (Object element : collection) {
            this.elementValidator.validate(element);
        }
    }

    private boolean isCollection(Class<?> fieldType) {
        return Collection.class.isAssignableFrom(fieldType);
    }

    private boolean isArray(Class<?> fieldType) {
        return Object[].class.isAssignableFrom(fieldType);
    }

    @Override
    public String getConstraintDesc() {
        return new StringBuilder(128).append(this.getFieldDesc()).append(this.allowEmpty ? " collection allow Empty" : " collection not allow empty").append(" size range:[" + this.minSize + "," + this.maxSize + "] elementValidator:" + this.elementValidator).toString();
    }
}

