package com.bxm.warcar.web.demo;

import com.bxm.warcar.utils.IpHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.ContentCachingRequestWrapper;

import javax.servlet.http.HttpServletRequest;
import java.util.concurrent.TimeUnit;

/**
 * @author allen
 * @since 2020-01-09
 */
@RestController
@Slf4j
public class WelcomeController {

    @GetMapping("/")
    public ResponseEntity<Object> welcome(HttpServletRequest request) {
        ContentCachingRequestWrapper requestWrapper = new ContentCachingRequestWrapper(request);
        return ResponseEntity.ok("Hello: " + request.getHeader("X-Forwarded-For"));
    }

    @PostMapping("/post")
    public ResponseEntity<Object> post(@RequestBody String json) {
        log.info("json: {}", json);
        return ResponseEntity.ok(json);
    }
}
