package com.bxm.warcar.web.demo;

import javax.servlet.http.HttpServletRequest;

import java.util.Set;

import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.web.util.*;

import lombok.extern.slf4j.Slf4j;

/**
 * 加解密，快速得到明文/密文<br/>
 *
 * @author kerry.jiang
 * @date 2020/11/5 18:25
 */
@Slf4j
@RestController
@RequestMapping("/textEncrypted")
public class TextEncryptedController {

    @Autowired
    private TextEncrypted textEncrypted;

    /**
     * 加密(PARAMS)
     */
    @RequestMapping(value = "/encrypt/params",method = RequestMethod.POST)
    @CrossOrigin(origins = "*")
    public ResponseEntity encryptParams(@RequestBody String url, HttpServletRequest request) {
        Integer cipher = NumberUtils.toInt(request.getHeader("cipher"), 2);
        String newUrl = textEncrypted.genGetUrl(cipher, request.getHeader("sign"), url);
        return ResponseEntity.ok(newUrl);
    }

    /**
     * 加密(JSON)
     */
    @RequestMapping(value = "/encrypt/json",method = RequestMethod.POST)
    @CrossOrigin(origins = "*")
    public ResponseEntity encryptJson(@RequestBody String json, HttpServletRequest request) throws Exception{
        Integer cipher = NumberUtils.toInt(request.getHeader("cipher"), 2);
        String res = textEncrypted.encrypt(cipher, request.getHeader("sign"), json);
        return ResponseEntity.ok(res);
    }

    /**
     * 解密(PARAMS)
     */
    @Encrypted(model = Object.class, plaintextFormat = TextFormat.PARAMS)
    @RequestMapping(value = "/decrypt/params",method = RequestMethod.POST)
    @CrossOrigin(origins = "*")
    public ResponseEntity decryptParams(@RequestBody EncryptedMessage<Object> message, HttpServletRequest request) {
        JSONObject json = JSON.parseObject(JsonHelper.convert(message.getObject()));
        StringBuilder sb = new StringBuilder();
        if(null != json){
            Set<String> set = json.keySet();
            for (String key : set) {
                sb.append("&").append(key).append("=")
                .append(json.get(key));
            }
        }
        return ResponseEntity.ok(sb);
    }

    /**
     * 解密(JSON)
     */
    @Encrypted(model = Object.class, plaintextFormat = TextFormat.JSON)
    @RequestMapping(value = "/decrypt/json",method = RequestMethod.POST)
    @CrossOrigin(origins = "*")
    public ResponseEntity decryptJson(@RequestBody EncryptedMessage<Object> message, HttpServletRequest request) {
        return ResponseEntity.ok(message.getObject());
    }
}
