package com.bxm.warcar.web.demo;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @author allen
 * @since 2020-01-09
 */
@Slf4j
@EnableAsync
@SpringBootApplication
public class WebDemoApplication implements WebMvcConfigurer, ApplicationContextAware, InitializingBean, DisposableBean {

    public static void main(String[] args) {
        SpringApplication.run(WebDemoApplication.class, args);
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        log.info(" ========= afterPropertiesSet");
    }

    @Override
    public void destroy() throws Exception {
        log.info(" ========= destroy");
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        log.info(" ========= setApplicationContext");
    }
}
