package com.bxm.warcar.web.demo;

import javax.servlet.http.HttpServletRequest;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.ContentCachingRequestWrapper;

import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.web.util.Encrypted;
import com.bxm.warcar.web.util.EncryptedMessage;
import com.bxm.warcar.web.util.TextFormat;
import com.bxm.warcar.web.util.serialization.PrimitiveSerialization;

import lombok.extern.slf4j.Slf4j;

/**
 * @author allen
 * @since 2020-01-09
 */
@RestController
@Slf4j
public class WelcomeController {

    @GetMapping("/")
    public ResponseEntity<Object> welcome(HttpServletRequest request) {
        ContentCachingRequestWrapper requestWrapper = new ContentCachingRequestWrapper(request);
        return ResponseEntity.ok("Hello: " + request.getHeader("X-Forwarded-For"));
    }

    @PostMapping("/post")
    public ResponseEntity<Object> post(@RequestBody String json) {
        log.info("json: {}", json);
        return ResponseEntity.ok(json);
    }

    @Encrypted(model = CipherRequest.class, encryptResponseEntity = true)
    @PostMapping("/cipher")
    public ResponseEntity<CipherResponse> cipher(@RequestBody EncryptedMessage<CipherRequest> message) {
        log.info(JsonHelper.convert(message));
        CipherRequest request = message.getObject();
        CipherResponse response = new CipherResponse();
        response.setMessage("Hello " + request.getName() + ", How are you today?");
//        return ResponseEntity.accepted().build();
        return ResponseEntity.ok(response);
    }

    @Encrypted(model = Integer.class, serialization = PrimitiveSerialization.class)
    @PostMapping("/cipher_integer")
    public ResponseEntity<Integer> cipherInteger(@RequestBody EncryptedMessage<Integer> message) {
        Integer integer = message.getObject();
        log.info(integer.toString());
        return ResponseEntity.ok(integer);
    }

    @Encrypted(model = CipherRequest.class, encryptResponseEntity = true, plaintextFormat = TextFormat.PARAMS)
    @GetMapping("/cipher")
    public ResponseEntity<CipherResponse> cipherGet(EncryptedMessage<CipherRequest> message) {
        log.info(JsonHelper.convert(message));
        CipherRequest request = message.getObject();
        CipherResponse response = new CipherResponse();
        response.setMessage("Hello " + request.getName() + ", How are you today?");
//        return ResponseEntity.accepted().build();
        return ResponseEntity.ok(response);
    }

    @Encrypted(model = Integer.class, serialization = PrimitiveSerialization.class)
    @GetMapping("/cipher_integer")
    public ResponseEntity<Integer> cipherIntegerGet(EncryptedMessage<Integer> message) {
        Integer integer = message.getObject();
        log.info(integer.toString());
        return ResponseEntity.ok(integer);
    }

    static class CipherRequest {

        private String name;
        private int age;

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return age;
        }

        public void setAge(int age) {
            this.age = age;
        }
    }

    static class CipherResponse {

        private String message;

        public String getMessage() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}
