/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.web.demo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.web.util.Encrypted;
import com.bxm.warcar.web.util.EncryptedMessage;
import com.bxm.warcar.web.util.TextEncrypted;
import com.bxm.warcar.web.util.TextFormat;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/textEncrypted"})
public class TextEncryptedController {
    private static final Logger log = LoggerFactory.getLogger(TextEncryptedController.class);
    @Autowired
    private TextEncrypted textEncrypted;

    @RequestMapping(value={"/encrypt/params"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"})
    public ResponseEntity encryptParams(@RequestBody String url, HttpServletRequest request) {
        Integer cipher = NumberUtils.toInt((String)request.getHeader("cipher"), (int)2);
        String newUrl = this.textEncrypted.genGetUrl(cipher, request.getHeader("sign"), url);
        return ResponseEntity.ok((Object)newUrl);
    }

    @RequestMapping(value={"/encrypt/json"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"})
    public ResponseEntity encryptJson(@RequestBody String json, HttpServletRequest request) throws Exception {
        Integer cipher = NumberUtils.toInt((String)request.getHeader("cipher"), (int)2);
        String res = this.textEncrypted.encrypt(cipher, request.getHeader("sign"), json);
        return ResponseEntity.ok((Object)res);
    }

    @Encrypted(model=Object.class, plaintextFormat=TextFormat.PARAMS)
    @RequestMapping(value={"/decrypt/params"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"})
    public ResponseEntity decryptParams(@RequestBody EncryptedMessage<Object> message, HttpServletRequest request) {
        JSONObject json = JSON.parseObject((String)JsonHelper.convert((Object)message.getObject()));
        StringBuilder sb = new StringBuilder();
        if (null != json) {
            Set set = json.keySet();
            for (String key : set) {
                sb.append("&").append(key).append("=").append(json.get((Object)key));
            }
        }
        return ResponseEntity.ok((Object)sb);
    }

    @Encrypted(model=Object.class, plaintextFormat=TextFormat.JSON)
    @RequestMapping(value={"/decrypt/json"}, method={RequestMethod.POST})
    @CrossOrigin(origins={"*"})
    public ResponseEntity decryptJson(@RequestBody EncryptedMessage<Object> message, HttpServletRequest request) {
        return ResponseEntity.ok((Object)message.getObject());
    }
}

