package com.bxm.warcar.web.util;

import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author allen
 * @date 2020-04-15
 * @since 1.0
 */
public final class WebContextUtils {

    public static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        if (!(requestAttributes instanceof ServletRequestAttributes)) {
            throw new RuntimeException("unsupported: " + requestAttributes.getClass().getName());
        }
        return ((ServletRequestAttributes) requestAttributes).getRequest();
    }

    public static HttpServletResponse getResponse() {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        if (!(requestAttributes instanceof ServletRequestAttributes)) {
            throw new RuntimeException("unsupported: " + requestAttributes.getClass().getName());
        }
        return ((ServletRequestAttributes) requestAttributes).getResponse();
    }
}
