package com.bxm.warcar.web.util;

import com.google.common.collect.Maps;

import java.util.Collection;
import java.util.Map;

/**
 * @author allen
 * @date 2020-10-10
 * @since 1.0
 */
public class EncryptorFactory {

    private final Map<Integer, Encryptor> encryptors = Maps.newHashMap();

    public EncryptorFactory(Collection<Encryptor> encryptorCollection) {
        for (Encryptor encryptor : encryptorCollection) {
            encryptors.put(encryptor.getVersion(), encryptor);
        }
    }

    Encryptor get(Integer version) {
        return encryptors.get(version);
    }
}
