package com.bxm.warcar.zk.test;

import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.zk.ZkClientHolder;
import com.bxm.warcar.zk.listener.ChildrenChangedListener;
import com.bxm.warcar.zk.listener.children.ChildrenChanged;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author allen
 * @since 2019-12-18
 */
@SpringBootApplication
public class ZkTestApplication {

    public static void main(String[] args) {
        SpringApplication.run(ZkTestApplication.class, args);
    }

    @Bean(initMethod = "init", destroyMethod = "destroy")
    public ChildrenChanged childrenChanged(ZkClientHolder zkClientHolder) {
        return new ChildrenChanged(zkClientHolder, "/warcar/data_sync", new ChildrenChangedListener() {
            @Override
            public void add(String path, byte[] data) {
                System.out.println(path);
                try {
                    Thread.sleep(1000L);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void remove(String path, byte[] data) {

            }

            @Override
            public void update(String path, byte[] data) {

            }

            @Override
            public ExecutorService getExecutorService() {
                return new ThreadPoolExecutor(100, 100, 5, TimeUnit.SECONDS,
                        new LinkedBlockingQueue<>(), new NamedThreadFactory("cclistener"));
            }
        });
    }
}
