package com.bxm.warcar.utils.file;

import com.bxm.warcar.utils.StringHelper;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * @author allen
 * @since 1.0.0
 */
public class SimpleFingerprintTracker implements FingerprintTracker {

    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleFingerprintTracker.class);
    private final String url;

    public SimpleFingerprintTracker(String url) {
        this.url = url;
    }

    @Override
    public String getFingerprint() {
        HttpURLConnection urlConnection = null;
        InputStream inputStream = null;
        try {
            urlConnection = (HttpURLConnection) new URL(url).openConnection();
            inputStream = urlConnection.getInputStream();
            byte[] buffer = new byte[inputStream.available()];
            IOUtils.readFully(inputStream, buffer);
            return StringHelper.convert(buffer);
        } catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("getFingerprint: ", e);
            }
            return null;
        } finally {
            IOUtils.closeQuietly(inputStream);
            if (null != urlConnection) {
                urlConnection.disconnect();
            }
        }
    }
}
