/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.cache.impls.redis;

import com.bxm.warcar.cache.DataExtractor;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.serialization.JSONSerialization;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.keyvalue.DefaultKeyValue;
import org.apache.commons.lang.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.Tuple;

@Deprecated
public class JedisFetcher
implements Fetcher {
    private final JedisPool jedisPool;
    private final JSONSerialization serialization;

    public JedisFetcher(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
        this.serialization = new JSONSerialization();
    }

    @Override
    public Object getClientOriginal() {
        return this.jedisPool;
    }

    @Override
    public <T> T fetch(KeyGenerator keyGenerator, Class<T> cls) {
        return this.fetch(keyGenerator, null, cls);
    }

    @Override
    public <T> T fetch(KeyGenerator keyGenerator, Class<T> cls, int expireTimeInSecond) {
        return this.fetch(keyGenerator, null, cls, expireTimeInSecond);
    }

    @Override
    public <T> T fetch(KeyGenerator keyGenerator, DataExtractor<T> dataExtractor, Class<T> cls) {
        return this.fetch(keyGenerator, dataExtractor, cls, 0);
    }

    @Override
    public <T> T fetch(KeyGenerator keyGenerator, DataExtractor<T> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        return this.fetchWithSelector(keyGenerator, dataExtractor, cls, expireTimeInSecond, -1);
    }

    @Override
    public <T> List<T> fetchList(KeyGenerator keyGenerator, Class<T> cls) {
        return this.fetchList(keyGenerator, null, cls);
    }

    @Override
    public <T> List<T> fetchList(KeyGenerator keyGenerator, DataExtractor<List<T>> dataExtractor, Class<T> cls) {
        return this.fetchList(keyGenerator, dataExtractor, cls, 0);
    }

    @Override
    public <T> List<T> fetchList(KeyGenerator keyGenerator, Class<T> cls, int expireTimeInSecond) {
        return this.fetchList(keyGenerator, null, cls, expireTimeInSecond);
    }

    @Override
    public <T> List<T> fetchList(KeyGenerator keyGenerator, DataExtractor<List<T>> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        return this.fetchListWithSelector(keyGenerator, dataExtractor, cls, expireTimeInSecond, -1);
    }

    @Override
    public <T> T hfetch(KeyGenerator keyGenerator, String field, Class<T> cls) {
        return this.hfetch(keyGenerator, field, null, cls);
    }

    @Override
    public <T> T hfetch(KeyGenerator keyGenerator, String field, Class<T> cls, int expireTimeInSecond) {
        return this.hfetch(keyGenerator, field, null, cls, expireTimeInSecond);
    }

    @Override
    public <T> T hfetch(KeyGenerator keyGenerator, String field, DataExtractor<T> dataExtractor, Class<T> cls) {
        return this.hfetch(keyGenerator, field, dataExtractor, cls, 0);
    }

    @Override
    public <T> T hfetch(KeyGenerator keyGenerator, String field, DataExtractor<T> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        return this.hfetchWithSelector(keyGenerator, field, dataExtractor, cls, expireTimeInSecond, -1);
    }

    @Override
    public <T> List<T> hfetchList(KeyGenerator keyGenerator, String field, Class<T> cls) {
        return this.hfetchList(keyGenerator, field, null, cls);
    }

    @Override
    public <T> List<T> hfetchList(KeyGenerator keyGenerator, String field, Class<T> cls, int expireTimeInSecond) {
        return this.hfetchList(keyGenerator, field, null, cls, expireTimeInSecond);
    }

    @Override
    public <T> List<T> hfetchList(KeyGenerator keyGenerator, String field, DataExtractor<List<T>> dataExtractor, Class<T> cls) {
        return this.hfetchList(keyGenerator, field, dataExtractor, cls, 0);
    }

    @Override
    public <T> List<T> hfetchList(KeyGenerator keyGenerator, String field, DataExtractor<List<T>> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        return this.hfetchListWithSelector(keyGenerator, field, dataExtractor, cls, expireTimeInSecond, -1);
    }

    @Override
    public <T> Map<String, T> hfetchall(KeyGenerator keyGenerator, Class<T> cls) {
        return this.hfetchall(keyGenerator, null, cls);
    }

    @Override
    public <T> Map<String, T> hfetchall(KeyGenerator keyGenerator, Class<T> cls, int expireTimeInSecond) {
        return this.hfetchall(keyGenerator, null, cls, expireTimeInSecond);
    }

    @Override
    public <T> Map<String, T> hfetchall(KeyGenerator keyGenerator, DataExtractor<Map<String, T>> dataExtractor, Class<T> cls) {
        return this.hfetchall(keyGenerator, dataExtractor, cls, 0);
    }

    @Override
    public <T> T fetchWithSelector(KeyGenerator keyGenerator, Class<T> cls, int selector) {
        return this.fetchWithSelector(keyGenerator, null, cls, selector);
    }

    @Override
    public <T> T fetchWithSelector(KeyGenerator keyGenerator, DataExtractor<T> dataExtractor, Class<T> cls, int selector) {
        return this.fetchWithSelector(keyGenerator, dataExtractor, cls, 0, selector);
    }

    @Override
    public <T> T fetchWithSelector(KeyGenerator keyGenerator, Class<T> cls, int expireTimeInSecond, int selector) {
        return this.fetchWithSelector(keyGenerator, null, cls, expireTimeInSecond, selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T fetchWithSelector(KeyGenerator keyGenerator, DataExtractor<T> dataExtractor, Class<T> cls, int expireTimeInSecond, int selector) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            String value;
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            if (null != (value = jedis.get(key))) {
                T t = this.serialization.deserialize(value, cls);
                return t;
            }
            T fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
            }
            if (null != fromStore) {
                jedis.set(key, this.serialization.serialize(fromStore));
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            T t = fromStore;
            return t;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public <T> List<T> fetchListWithSelector(KeyGenerator keyGenerator, Class<T> cls, int selector) {
        return this.fetchListWithSelector(keyGenerator, null, cls, selector);
    }

    @Override
    public <T> List<T> fetchListWithSelector(KeyGenerator keyGenerator, DataExtractor<List<T>> dataExtractor, Class<T> cls, int selector) {
        return this.fetchListWithSelector(keyGenerator, dataExtractor, cls, 0, selector);
    }

    @Override
    public <T> List<T> fetchListWithSelector(KeyGenerator keyGenerator, Class<T> cls, int expireTimeInSecond, int selector) {
        return this.fetchListWithSelector(keyGenerator, null, cls, expireTimeInSecond, selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> fetchListWithSelector(KeyGenerator keyGenerator, DataExtractor<List<T>> dataExtractor, Class<T> cls, int expireTimeInSecond, int selector) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            String value;
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            if (null != (value = jedis.get(key))) {
                List<T> list = this.serialization.deserializeList(value, cls);
                return list;
            }
            List<T> fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
            }
            if (null != fromStore) {
                jedis.set(key, this.serialization.serialize(fromStore));
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            List<T> list = fromStore;
            return list;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public <T> T hfetchWithSelector(KeyGenerator keyGenerator, String field, Class<T> cls, int selector) {
        return this.hfetchWithSelector(keyGenerator, field, null, cls, selector);
    }

    @Override
    public <T> T hfetchWithSelector(KeyGenerator keyGenerator, String field, DataExtractor<T> dataExtractor, Class<T> cls, int selector) {
        return this.hfetchWithSelector(keyGenerator, field, dataExtractor, cls, 0, selector);
    }

    @Override
    public <T> T hfetchWithSelector(KeyGenerator keyGenerator, String field, Class<T> cls, int expireTimeInSecond, int selector) {
        return this.hfetchWithSelector(keyGenerator, field, null, cls, expireTimeInSecond, selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T hfetchWithSelector(KeyGenerator keyGenerator, String field, DataExtractor<T> dataExtractor, Class<T> cls, int expireTimeInSecond, int selector) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        if (StringUtils.isBlank((String)field)) {
            throw new NullPointerException("field");
        }
        Jedis jedis = null;
        try {
            String value;
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            if (null != (value = jedis.hget(key, field))) {
                T t = this.serialization.deserialize(value, cls);
                return t;
            }
            T fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
            }
            if (null != fromStore) {
                jedis.hset(key, field, this.serialization.serialize(fromStore));
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            T t = fromStore;
            return t;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public <T> List<T> hfetchListWithSelector(KeyGenerator keyGenerator, String field, Class<T> cls, int selector) {
        return this.hfetchListWithSelector(keyGenerator, field, cls, 0, selector);
    }

    @Override
    public <T> List<T> hfetchListWithSelector(KeyGenerator keyGenerator, String field, DataExtractor<List<T>> dataExtractor, Class<T> cls, int selector) {
        return this.hfetchListWithSelector(keyGenerator, field, dataExtractor, cls, 0, selector);
    }

    @Override
    public <T> List<T> hfetchListWithSelector(KeyGenerator keyGenerator, String field, Class<T> cls, int expireTimeInSecond, int selector) {
        return this.hfetchListWithSelector(keyGenerator, field, null, cls, expireTimeInSecond, selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> hfetchListWithSelector(KeyGenerator keyGenerator, String field, DataExtractor<List<T>> dataExtractor, Class<T> cls, int expireTimeInSecond, int selector) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        if (StringUtils.isBlank((String)field)) {
            throw new NullPointerException("field");
        }
        Jedis jedis = null;
        try {
            String value;
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            if (null != (value = jedis.hget(key, field))) {
                List<T> list = this.serialization.deserializeList(value, cls);
                return list;
            }
            List<T> fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
            }
            if (null != fromStore) {
                jedis.hset(key, field, this.serialization.serialize(fromStore));
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            List<T> list = fromStore;
            return list;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public <T> Map<String, T> hfetchallWithSelector(KeyGenerator keyGenerator, Class<T> cls, int selector) {
        return this.hfetchallWithSelector(keyGenerator, null, cls, selector);
    }

    @Override
    public <T> Map<String, T> hfetchallWithSelector(KeyGenerator keyGenerator, DataExtractor<Map<String, T>> dataExtractor, Class<T> cls, int selector) {
        return this.hfetchallWithSelector(keyGenerator, dataExtractor, cls, 0, selector);
    }

    @Override
    public <T> Map<String, T> hfetchallWithSelector(KeyGenerator keyGenerator, Class<T> cls, int expireTimeInSecond, int selector) {
        return this.hfetchallWithSelector(keyGenerator, null, cls, expireTimeInSecond, selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<String, T> hfetchallWithSelector(KeyGenerator keyGenerator, DataExtractor<Map<String, T>> dataExtractor, Class<T> cls, int expireTimeInSecond, int selector) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            Object hscan;
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            HashMap rst = Maps.newHashMap();
            String startCursor = "0";
            String cursor = "0";
            do {
                hscan = jedis.hscan(key, cursor, new ScanParams().count(Integer.valueOf(10000)));
                cursor = hscan.getStringCursor();
                List result = hscan.getResult();
                if (!CollectionUtils.isNotEmpty((Collection)result)) continue;
                for (Map.Entry entry : result) {
                    String k = (String)entry.getKey();
                    String v = (String)entry.getValue();
                    rst.put(k, this.serialization.deserialize(v, cls));
                }
            } while (!cursor.equals("0"));
            if (MapUtils.isNotEmpty((Map)rst)) {
                hscan = rst;
                return hscan;
            }
            Map<String, T> fromStore = null;
            if (null != dataExtractor) {
                fromStore = dataExtractor.extract();
            }
            if (null != fromStore) {
                Set<Map.Entry<String, T>> entries = fromStore.entrySet();
                for (Map.Entry entry : entries) {
                    jedis.hset(key, (String)entry.getKey(), this.serialization.serialize(entry.getValue()));
                }
                if (expireTimeInSecond > 0) {
                    jedis.expire(key, expireTimeInSecond);
                }
            }
            Map<String, T> map = fromStore;
            return map;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public Long pfCount(KeyGenerator keyGenerator) {
        return this.pfCount(keyGenerator, -1);
    }

    @Override
    public Long pfCount(KeyGenerator keyGenerator, int expireTimeInSecond) {
        return this.pfCountWithSelector(keyGenerator, expireTimeInSecond, -1);
    }

    @Override
    public Long pfCountWithSelector(KeyGenerator keyGenerator, int selector) {
        return this.pfCountWithSelector(keyGenerator, -1, selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long pfCountWithSelector(KeyGenerator keyGenerator, int expireTimeInSecond, int selector) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            Long count;
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            if (null != (count = Long.valueOf(jedis.pfcount(key))) && count > 0L && expireTimeInSecond > 0) {
                jedis.expire(key, expireTimeInSecond);
            }
            Long l = count;
            return l;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public <T> List<T> zfetchList(KeyGenerator keyGenerator, Class<T> cls) {
        return this.zfetchList(keyGenerator, cls, -1);
    }

    @Override
    public <T> List<T> zfetchList(KeyGenerator keyGenerator, Class<T> cls, int expireTimeInSecond) {
        return this.zfetchListWithSelector(keyGenerator, cls, expireTimeInSecond, -1);
    }

    @Override
    public <T> List<T> zfetchListWithSelector(KeyGenerator keyGenerator, Class<T> cls, int selector) {
        return this.zfetchListWithSelector(keyGenerator, cls, -1, selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> zfetchListWithSelector(KeyGenerator keyGenerator, Class<T> cls, int expireTimeInSecond, int selector) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            ArrayList<T> rs = new ArrayList<T>();
            String cursor = "0";
            ScanParams scanParams = new ScanParams().count(Integer.valueOf(10000));
            do {
                ScanResult zscan = jedis.zscan(key, cursor, scanParams);
                cursor = zscan.getStringCursor();
                List result = zscan.getResult();
                if (!CollectionUtils.isNotEmpty((Collection)result)) continue;
                for (Tuple t : result) {
                    rs.add(this.serialization.deserialize(t.getElement(), cls));
                }
            } while (!"0".equals(cursor));
            if (rs.size() > 0 && expireTimeInSecond > 0) {
                jedis.expire(key, expireTimeInSecond);
            }
            ArrayList<T> arrayList = rs;
            return arrayList;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public <T> List<DefaultKeyValue> zfetchAll(KeyGenerator keyGenerator, Class<T> cls) {
        return this.zfetchAll(keyGenerator, cls, -1);
    }

    @Override
    public <T> List<DefaultKeyValue> zfetchAll(KeyGenerator keyGenerator, Class<T> cls, int expireTimeInSecond) {
        return this.zfetchAllWithSelector(keyGenerator, cls, expireTimeInSecond, -1);
    }

    @Override
    public <T> List<DefaultKeyValue> zfetchAllWithSelector(KeyGenerator keyGenerator, Class<T> cls, int selector) {
        return this.zfetchAllWithSelector(keyGenerator, cls, -1, selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<DefaultKeyValue> zfetchAllWithSelector(KeyGenerator keyGenerator, Class<T> cls, int expireTimeInSecond, int selector) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            ArrayList<DefaultKeyValue> rs = new ArrayList<DefaultKeyValue>();
            String cursor = "0";
            ScanParams scanParams = new ScanParams().count(Integer.valueOf(10000));
            do {
                ScanResult zscan = jedis.zscan(key, cursor, scanParams);
                cursor = zscan.getStringCursor();
                List result = zscan.getResult();
                if (!CollectionUtils.isNotEmpty((Collection)result)) continue;
                for (Tuple t : result) {
                    DefaultKeyValue kv = new DefaultKeyValue();
                    kv.setKey(this.serialization.deserialize(t.getElement(), cls));
                    kv.setValue((Object)t.getScore());
                    rs.add(kv);
                }
            } while (!"0".equals(cursor));
            if (rs.size() > 0 && expireTimeInSecond > 0) {
                jedis.expire(key, expireTimeInSecond);
            }
            ArrayList<DefaultKeyValue> arrayList = rs;
            return arrayList;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public <T> Map<String, T> hfetchall(KeyGenerator keyGenerator, DataExtractor<Map<String, T>> dataExtractor, Class<T> cls, int expireTimeInSecond) {
        return this.hfetchallWithSelector(keyGenerator, dataExtractor, cls, expireTimeInSecond, -1);
    }

    @Override
    public boolean exists(KeyGenerator keyGenerator) {
        return this.existsWithSelector(keyGenerator, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existsWithSelector(KeyGenerator keyGenerator, int selector) {
        if (null == keyGenerator) {
            throw new NullPointerException("getKeyGenerator");
        }
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((String)key)) {
            throw new NullPointerException("key");
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            if (selector >= 0) {
                jedis.select(selector);
            }
            boolean bl = jedis.exists(key);
            return bl;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

