/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.dc.dot.impl;

import com.bxm.warcar.integration.dc.dot.Dot;
import com.bxm.warcar.integration.dc.dot.DotParameter;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class DefaultDotImpl
implements Dot {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDotImpl.class);
    private final String dotUrl;
    private final RestTemplate rest;

    public DefaultDotImpl() {
        this("http://61.130.182.195:2080/dot/s.gif");
    }

    public DefaultDotImpl(String dotUrl) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)dotUrl));
        this.dotUrl = dotUrl;
        this.rest = new RestTemplateBuilder(new RestTemplateCustomizer[0]).setConnectTimeout(1000).setReadTimeout(1000).build();
    }

    @Override
    public String doGet(DotParameter parameter) {
        return this.doGet(parameter, String.class);
    }

    @Override
    public <T> T doGet(DotParameter parameter, Class<T> responseType) {
        return this.doGet0(parameter, responseType);
    }

    @Override
    public String doGet(Map<String, Object> parameter) {
        return this.doGet(parameter, String.class);
    }

    @Override
    public <T> T doGet(Map<String, Object> parameter, Class<T> responseType) {
        return this.doGet0(parameter, responseType);
    }

    private <T> T doGet0(Map<String, Object> parameter, Class<T> responseType) {
        ResponseEntity responseEntity;
        HttpStatus statusCode;
        String url = this.dotUrl;
        StringBuilder urlConnector = new StringBuilder(StringUtils.removeEnd((String)this.dotUrl, (String)"?"));
        if (MapUtils.isNotEmpty(parameter)) {
            urlConnector.append("?");
            for (Map.Entry<String, Object> entry : parameter.entrySet()) {
                Object value = entry.getValue();
                if (null == value) continue;
                urlConnector.append(entry.getKey()).append("={").append(entry.getKey()).append("}&");
            }
            url = StringUtils.removeEnd((String)urlConnector.toString(), (String)"&");
        }
        if ((statusCode = (responseEntity = this.rest.getForEntity(url, responseType, parameter)).getStatusCode()) != HttpStatus.OK) {
            LOGGER.warn("doGet0 code: {} for url: {}", (Object)statusCode, (Object)url);
        }
        return (T)responseEntity.getBody();
    }

    @Override
    public String doPost(Map<String, Object> parameter) {
        return this.doPost(parameter, String.class);
    }

    @Override
    public <T> T doPost(Map<String, Object> parameter, Class<T> responseType) {
        return this.doPost0(parameter, responseType);
    }

    private <T> T doPost0(Map<String, Object> parameter, Class<T> responseType) {
        String url = this.dotUrl;
        ResponseEntity responseEntity = this.rest.postForEntity(url, parameter, responseType, new Object[0]);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (statusCode != HttpStatus.OK) {
            LOGGER.warn("doPost0 code: {} for url: {}", (Object)statusCode, (Object)url);
        }
        return (T)responseEntity.getBody();
    }
}

