package com.bxm.warcar.integration.taskcounter;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

import java.util.concurrent.atomic.AtomicLong;

public class TaskCountBlockProcessor implements DisposableBean {

    private static final Logger LOGGER = LoggerFactory.getLogger(TaskCountBlockProcessor.class);
    private final TaskCountStatistics taskMetrics;

    public TaskCountBlockProcessor(TaskCountStatistics taskMetrics) {
        Preconditions.checkNotNull(taskMetrics);
        this.taskMetrics = taskMetrics;
    }

    @Override
    public void destroy() throws Exception {
        AtomicLong tasks = taskMetrics.getTasks();

        while (tasks.get() > 0) {
            try {
                Thread.sleep(1000);
            } catch (InterruptedException ignore) {
            }

            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("{} more tasks have not been completed", tasks.get());
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("OK, All task has been processed.");
        }
    }
}
