/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.dc.dot;

import com.bxm.warcar.integration.dc.dot.DotParameter;
import com.bxm.warcar.integration.dc.dot.ModelTypeEnum;
import com.bxm.warcar.integration.dc.dot.VerEnum;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

public class DotParameterFactory {
    private VerEnum verEnum;
    private DotParameter parameters = new DotParameter();

    private DotParameterFactory() {
    }

    public static DotParameterFactory create() {
        return DotParameterFactory.create(VerEnum.V2);
    }

    public static DotParameterFactory create(VerEnum ver) {
        return DotParameterFactory.create("ads", ver);
    }

    public static DotParameterFactory create(String product, VerEnum ver) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)product));
        Preconditions.checkNotNull((Object)((Object)ver));
        DotParameterFactory factory = new DotParameterFactory().p(product);
        factory.verEnum = ver;
        return factory;
    }

    public DotParameterFactory p(String p) {
        this.parameters.put("p", p);
        return this;
    }

    public DotParameterFactory ip(String ip) {
        this.parameters.put("ip", ip);
        return this;
    }

    public DotParameterFactory ua(String userAgent) {
        this.parameters.put("user_agent", userAgent);
        return this;
    }

    public DotParameterFactory referrer(String referrer) {
        this.parameters.put("referrer", referrer);
        return this;
    }

    public DotParameterFactory sh(Integer sh) {
        this.parameters.put("sh", sh);
        return this;
    }

    public DotParameterFactory sw(Integer sw) {
        this.parameters.put("sw", sw);
        return this;
    }

    public DotParameterFactory mt(ModelTypeEnum mt) {
        if (this.verEnum == VerEnum.V1) {
            this.parameters.put("mt", mt.getDotV1());
        } else if (this.verEnum == VerEnum.V2) {
            this.parameters.put("mt", mt.getDotV2());
        }
        return this;
    }

    public DotParameterFactory bxmid(String bxmid) {
        this.parameters.put("bxm_id", bxmid);
        return this;
    }

    public DotParameterFactory x(Integer x) {
        this.parameters.put("x", x);
        return this;
    }

    public DotParameterFactory y(Integer y) {
        this.parameters.put("y", y);
        return this;
    }

    public DotParameterFactory popupId(Object popupId) {
        this.parameters.put("popupId", popupId);
        return this;
    }

    public DotParameterFactory awardId(Object awardid) {
        this.parameters.put("awardid", awardid);
        return this;
    }

    public DotParameterFactory assetsId(Object assetsId) {
        this.parameters.put("assetsId", assetsId);
        return this;
    }

    public DotParameterFactory scene(String scene) {
        this.parameters.put("scene", scene);
        return this;
    }

    public DotParameterFactory ts(Long ts) {
        this.parameters.put("ts", ts);
        return this;
    }

    public DotParameterFactory price(Long price) {
        this.parameters.put("price", price);
        return this;
    }

    public DotParameterFactory stype(Integer stype) {
        this.parameters.put("s_type", stype);
        return this;
    }

    public DotParameterFactory appkey(String appkey) {
        this.parameters.put("appkey", appkey);
        return this;
    }

    public DotParameterFactory business(String business) {
        this.parameters.put("business", business);
        return this;
    }

    public DotParameterFactory activityId(Object activityId) {
        this.parameters.put("activityid", activityId);
        return this;
    }

    public DotParameterFactory uid(String uid) {
        this.parameters.put("uid", uid);
        return this;
    }

    public DotParameterFactory spm(String spm) {
        this.parameters.put("spm", spm);
        return this;
    }

    public DotParameterFactory imei(String imei) {
        this.parameters.put("i", imei);
        return this;
    }

    public DotParameterFactory idfa(String idfa) {
        this.parameters.put("f", idfa);
        return this;
    }

    public DotParameterFactory ext(String ext) {
        this.parameters.put("ext", ext);
        return this;
    }

    public DotParameterFactory locaurl(String locaurl) {
        this.parameters.put("locaurl", locaurl);
        return this;
    }

    public DotParameterFactory modelType(String modelType) {
        this.parameters.put("modeltype", modelType);
        return this;
    }

    public DotParameterFactory userAgent(String userAgent) {
        this.parameters.put("user_agent", userAgent);
        return this;
    }

    public DotParameterFactory status(String status) {
        this.parameters.put("status", status);
        return this;
    }

    public DotParameter build() {
        return this.parameters;
    }
}

