/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.dc.dot.impl;

import com.bxm.warcar.integration.dc.dot.Dot;
import com.bxm.warcar.integration.dc.dot.DotParameter;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class DefaultDotImpl
implements Dot {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDotImpl.class);
    private final String dotUrl;
    private final RestTemplate rest;

    public DefaultDotImpl() {
        this("http://log.cudaojia.com:10080/dot/s.gif");
    }

    public DefaultDotImpl(String dotUrl) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)dotUrl));
        this.dotUrl = dotUrl;
        this.rest = new RestTemplateBuilder(new RestTemplateCustomizer[0]).setConnectTimeout(1000).setReadTimeout(1000).build();
    }

    @Override
    public String doGet(DotParameter parameter) {
        return this.doGet(parameter, String.class);
    }

    @Override
    public <T> T doGet(DotParameter parameter, Class<T> responseType) {
        ResponseEntity responseEntity;
        HttpStatus statusCode;
        String url = this.dotUrl;
        StringBuilder urlConnector = new StringBuilder(StringUtils.removeEnd((String)this.dotUrl, (String)"?"));
        if (MapUtils.isNotEmpty((Map)parameter)) {
            urlConnector.append("?");
            for (Map.Entry entry : parameter.entrySet()) {
                Object value = entry.getValue();
                if (null == value) continue;
                urlConnector.append((String)entry.getKey()).append("=").append(this.urlEncode(value.toString())).append("&");
            }
            url = StringUtils.removeEnd((String)urlConnector.toString(), (String)"&");
        }
        if ((statusCode = (responseEntity = this.rest.getForEntity(url, responseType, new Object[0])).getStatusCode()) != HttpStatus.OK) {
            LOGGER.warn("code: {} for url: {}", (Object)statusCode, (Object)url);
        }
        return (T)responseEntity.getBody();
    }

    private String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }
}

