/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.eventbus;

import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class AbstractEventPark
implements EventPark,
ApplicationListener<ApplicationReadyEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEventPark.class);

    protected abstract EventBus getEventBus();

    protected abstract String getEventParkName();

    @Override
    public void register(EventListener listener) {
        Method[] methods;
        EventBus eventBus = this.getEventBus();
        eventBus.register((Object)listener);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Registering listeners to {}: {}", (Object)this.getEventParkName(), (Object)listener);
        }
        boolean noSubscribeMethod = true;
        for (Method method : methods = listener.getClass().getMethods()) {
            if (!method.isAnnotationPresent(Subscribe.class)) continue;
            noSubscribeMethod = false;
        }
        if (noSubscribeMethod) {
            throw new RuntimeException(listener.getClass() + " must have an @Subscribe method!");
        }
    }

    @Override
    public void unregister(EventListener listener) {
        this.getEventBus().unregister((Object)listener);
    }

    @Override
    public void post(EventObject eventObject) {
        this.getEventBus().post((Object)eventObject);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("EventBus post event: {}", (Object)eventObject);
        }
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map beansOfType = applicationContext.getBeansOfType(EventListener.class);
        Set entries = beansOfType.entrySet();
        for (Map.Entry entry : entries) {
            this.register((EventListener)entry.getValue());
        }
    }
}

